/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractInternationalString;

public class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -8636012022904092254L;
    protected final String resources;
    protected final String key;

    public ResourceInternationalString(String resources, String key) {
        ArgumentChecks.ensureNonNull("resources", resources);
        ArgumentChecks.ensureNonNull("key", key);
        this.resources = resources;
        this.key = key;
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(this.resources, locale);
    }

    @Override
    public String toString(Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.ROOT;
        }
        return this.getBundle(locale).getString(this.key);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ResourceInternationalString that = (ResourceInternationalString)object;
            return this.key.equals(that.key) && this.resources.equals(that.resources);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.resources.hashCode() ^ 0x1ACC89A2;
    }
}

