/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.CodeListFilter;
import org.apache.sis.util.iso.DefaultInternationalString;
import org.apache.sis.util.iso.ResourceInternationalString;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public final class Types
extends Static {
    private static final char SEPARATOR = '.';
    private static Map<Object, Object> typeForNames;

    private Types() {
    }

    public static String getStandardName(Class<?> type) {
        String id;
        UML uml;
        if (type != null && (uml = type.getAnnotation(UML.class)) != null && (id = uml.identifier()) != null && !id.isEmpty()) {
            return id.intern();
        }
        return null;
    }

    public static String getListName(CodeList<?> code) {
        if (code == null) {
            return null;
        }
        Class<?> type = code.getClass();
        String id = Types.getStandardName(type);
        return id != null ? id : type.getSimpleName();
    }

    public static String getCodeName(CodeList<?> code) {
        if (code == null) {
            return null;
        }
        String id = code.identifier();
        return id != null && !id.isEmpty() ? id : code.name();
    }

    public static String getCodeLabel(CodeList<?> code) {
        if (code == null) {
            return null;
        }
        String id = code.identifier();
        String name = code.name();
        if (id == null) {
            id = name;
        }
        for (String candidate : code.names()) {
            if (candidate.equals(name) || candidate.length() < id.length()) continue;
            id = candidate;
        }
        return CharSequences.camelCaseToSentence(id).toString();
    }

    public static InternationalString getCodeTitle(CodeList<?> code) {
        return code != null ? new CodeTitle(code) : null;
    }

    public static InternationalString getDescription(CodeList<?> code) {
        String resources;
        if (code != null && (resources = Types.getResources(code.getClass().getName())) != null) {
            return new Description(resources, Description.resourceKey(code));
        }
        return null;
    }

    public static InternationalString getDescription(Class<?> type) {
        String resources;
        String name = Types.getStandardName(type);
        if (name != null && (resources = Types.getResources(type.getName())) != null) {
            return new Description(resources, name);
        }
        return null;
    }

    public static InternationalString getDescription(Class<?> type, String property) {
        String resources;
        String name;
        if (property != null && (name = Types.getStandardName(type)) != null && (resources = Types.getResources(type.getName())) != null) {
            return new Description(resources, name + '.' + property);
        }
        return null;
    }

    static String getResources(String classname) {
        String resources = "org.opengis.metadata.Descriptions";
        if (classname.regionMatches(0, resources, 0, 21)) {
            return resources;
        }
        return null;
    }

    public static <T extends CodeList<?>> T[] getCodeValues(Class<T> codeType) {
        Object values;
        try {
            values = codeType.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (NoSuchMethodException e) {
            values = Array.newInstance(codeType, 0);
        }
        catch (IllegalAccessException e) {
            values = Array.newInstance(codeType, 0);
        }
        return (CodeList[])values;
    }

    public static synchronized Class<?> forStandardName(String identifier) {
        Class<?> type;
        Object value;
        if (identifier == null) {
            return null;
        }
        if (typeForNames == null) {
            Class<Types> c = Types.class;
            InputStream in = c.getResourceAsStream("class-index.properties");
            if (in == null) {
                throw new MissingResourceException("class-index.properties", c.getName(), identifier);
            }
            Properties props = new Properties();
            try {
                props.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
            catch (IllegalArgumentException e) {
                throw new BackingStoreException(e);
            }
            typeForNames = new HashMap<Object, Object>(props);
            JDK8.putIfAbsent(typeForNames, "MI_SensorTypeCode", "org.apache.sis.internal.metadata.SensorType");
        }
        if ((value = typeForNames.get(identifier)) == null || value instanceof Class) {
            return (Class)value;
        }
        try {
            type = Class.forName((String)value);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException((String)value, e);
        }
        typeForNames.put(identifier, type);
        return type;
    }

    public static <T extends Enum<T>> T forEnumName(Class<T> enumType, String name) {
        if ((name = CharSequences.trimWhitespaces(name)) != null && !name.isEmpty()) {
            try {
                return Enum.valueOf(enumType, name);
            }
            catch (IllegalArgumentException e) {
                Enum[] values = (Enum[])enumType.getEnumConstants();
                if (values == null) {
                    throw e;
                }
                for (Enum code : values) {
                    if (!CodeListFilter.accept(code.name(), name)) continue;
                    return (T)((Enum)enumType.cast(code));
                }
            }
        }
        return null;
    }

    public static <T extends CodeList<T>> T forCodeName(Class<T> codeType, String name, boolean canCreate) {
        if ((name = CharSequences.trimWhitespaces(name)) == null || name.isEmpty()) {
            return null;
        }
        String typeName = codeType.getName();
        try {
            Class.forName(typeName, true, codeType.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(typeName, e);
        }
        return CodeList.valueOf(codeType, new CodeListFilter(name, canCreate));
    }

    public static CodeList<?> forCodeTitle(CharSequence title) {
        return title instanceof CodeTitle ? ((CodeTitle)title).code : null;
    }

    public static InternationalString toInternationalString(Map<String, ?> properties, String prefix) throws IllegalArgumentException {
        SortedMap sorted;
        ArgumentChecks.ensureNonEmpty("prefix", prefix);
        if (properties == null) {
            return null;
        }
        boolean isSorted = false;
        if (properties instanceof SortedMap && (sorted = (SortedMap)properties).comparator() == null) {
            properties = sorted.tailMap(prefix);
            isSorted = true;
        }
        CharSequence i18n = null;
        Locale firstLocale = null;
        DefaultInternationalString dis = null;
        int offset = prefix.length();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value;
            Locale locale;
            String key = entry.getKey();
            if (key == null) continue;
            if (!key.startsWith(prefix)) {
                if (!isSorted) continue;
                break;
            }
            if (key.length() == offset) {
                locale = Locale.ROOT;
            } else {
                char c = key.charAt(offset);
                if (c != '_') {
                    if (!isSorted || c <= '_') continue;
                    break;
                }
                int s = offset + 1;
                try {
                    locale = Locales.parse(key, s);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException(Errors.getResources(properties).getString((short)36, '(' + key.substring(0, s) + '\uff09' + key.substring(s), e));
                }
            }
            if ((value = entry.getValue()) == null) continue;
            if (!(value instanceof CharSequence)) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)40, key, value.getClass()));
            }
            if (i18n == null) {
                i18n = (CharSequence)value;
                firstLocale = locale;
                continue;
            }
            if (dis == null) {
                dis = new DefaultInternationalString();
                dis.add(firstLocale, i18n);
                i18n = dis;
            }
            dis.add(locale, (CharSequence)value);
        }
        return Types.toInternationalString(i18n);
    }

    public static InternationalString toInternationalString(CharSequence string) {
        if (string == null || string instanceof InternationalString) {
            return (InternationalString)string;
        }
        return new SimpleInternationalString(string.toString());
    }

    public static InternationalString[] toInternationalStrings(CharSequence ... strings) {
        if (strings == null || strings instanceof InternationalString[]) {
            return (InternationalString[])strings;
        }
        InternationalString[] copy = new InternationalString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            copy[i] = Types.toInternationalString(strings[i]);
        }
        return copy;
    }

    private static final class CodeTitle
    extends Description {
        private static final long serialVersionUID = 3306532357801489365L;
        final CodeList<?> code;

        CodeTitle(CodeList<?> code) {
            super("org.opengis.metadata.CodeLists", CodeTitle.resourceKey(code));
            this.code = code;
        }

        @Override
        String fallback() {
            return Types.getCodeLabel(this.code);
        }
    }

    private static class Description
    extends ResourceInternationalString {
        private static final long serialVersionUID = -6202647167398898834L;
        private static final ClassLoader CLASSLOADER = UML.class.getClassLoader();

        Description(String resources, String key) {
            super(resources, key);
        }

        @Override
        protected final ResourceBundle getBundle(Locale locale) {
            return ResourceBundle.getBundle(this.resources, locale, CLASSLOADER);
        }

        @Override
        public final String toString(Locale locale) {
            try {
                return super.toString(locale);
            }
            catch (MissingResourceException e) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.util.resources"), ResourceInternationalString.class, "toString", e);
                return this.fallback();
            }
        }

        String fallback() {
            return CharSequences.camelCaseToSentence(this.key.substring(this.key.lastIndexOf(46) + 1)).toString();
        }

        static String resourceKey(CodeList<?> code) {
            String key = Types.getCodeName(code);
            if (key.indexOf(46) < 0) {
                key = Types.getListName(code) + '.' + key;
            }
            return key;
        }
    }
}

