/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.util.logging.LoggerAdapter;

final class DualLogger
extends LoggerAdapter {
    private final Logger first;
    private final Logger second;

    DualLogger(String name, Logger first, Logger second) {
        super(name);
        this.first = first;
        this.second = second;
    }

    @Override
    public void setLevel(Level level) {
        this.first.setLevel(level);
        this.second.setLevel(level);
    }

    @Override
    public Level getLevel() {
        Level v1 = this.first.getLevel();
        Level v2 = this.second.getLevel();
        return v1.intValue() < v2.intValue() ? v1 : v2;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.first.isLoggable(level) || this.second.isLoggable(level);
    }

    @Override
    public void log(Level level, String message) {
        this.first.log(level, message);
        this.second.log(level, message);
    }

    @Override
    public void log(Level level, String message, Throwable thrown) {
        this.first.log(level, message, thrown);
        this.second.log(level, message, thrown);
    }

    @Override
    public void severe(String message) {
        this.first.severe(message);
        this.second.severe(message);
    }

    @Override
    public void warning(String message) {
        this.first.warning(message);
        this.second.warning(message);
    }

    @Override
    public void info(String message) {
        this.first.info(message);
        this.second.info(message);
    }

    @Override
    public void config(String message) {
        this.first.config(message);
        this.second.config(message);
    }

    @Override
    public void fine(String message) {
        this.first.fine(message);
        this.second.fine(message);
    }

    @Override
    public void finer(String message) {
        this.first.finer(message);
        this.second.finer(message);
    }

    @Override
    public void finest(String message) {
        this.first.finest(message);
        this.second.finest(message);
    }
}

