/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.DualLoggerFactory;
import org.apache.sis.util.logging.LoggerFactory;

public final class Logging
extends Static {
    private static final int LEVEL_THRESHOLD_FOR_STACKTRACE = 600;
    private static volatile LoggerFactory<?> factory;

    private Logging() {
    }

    public static void setLoggerFactory(LoggerFactory<?> factory) {
        Logging.factory = factory;
    }

    public static LoggerFactory<?> getLoggerFactory() {
        return factory;
    }

    public static Logger getLogger(String name) {
        Logger logger;
        LoggerFactory<?> factory = Logging.factory;
        if (factory != null && (logger = factory.getLogger(name)) != null) {
            return logger;
        }
        return Logger.getLogger(name);
    }

    static Logger getLogger(Class<?> classe) {
        Class<?> outer;
        while ((outer = classe.getEnclosingClass()) != null) {
            classe = outer;
        }
        String name = classe.getName();
        int separator = name.lastIndexOf(46);
        String string = name = separator >= 1 ? name.substring(0, separator) : "";
        if (name.startsWith("org.apache.sis.internal.")) {
            name = "org.apache.sis" + name.substring(23);
        }
        return Logging.getLogger(name);
    }

    public static void log(Class<?> classe, String method, LogRecord record) {
        Logger logger;
        record.setSourceClassName(classe.getCanonicalName());
        record.setSourceMethodName(method);
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            logger = Logging.getLogger(classe);
            record.setLoggerName(logger.getName());
        } else {
            logger = Logging.getLogger(loggerName);
        }
        logger.log(record);
    }

    @Deprecated
    public static boolean unexpectedException(Logger logger, Throwable error) {
        return Logging.unexpectedException(logger, null, null, error, Level.WARNING);
    }

    public static boolean unexpectedException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.WARNING);
    }

    private static boolean unexpectedException(Logger logger, String classe, String method, Throwable error, Level level) {
        if (error == null) {
            return false;
        }
        if (logger == null && classe != null) {
            int separator = classe.lastIndexOf(46);
            StackTraceElement[] paquet = separator >= 1 ? classe.substring(0, separator - 1) : "";
            logger = Logging.getLogger((String)paquet);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        if (logger == null || classe == null || method == null) {
            String paquet = logger != null ? logger.getName() : null;
            for (StackTraceElement element : error.getStackTrace()) {
                char separator;
                String classname = element.getClassName();
                if (classe != null) {
                    if (!classname.equals(classe)) {
                        continue;
                    }
                } else if (paquet != null) {
                    if (!classname.startsWith(paquet)) continue;
                    int length = paquet.length();
                    if (classname.length() > length && Character.isJavaIdentifierPart(separator = (char)classname.charAt(length))) continue;
                }
                String methodName = element.getMethodName();
                if (method != null && !methodName.equals(method)) continue;
                if (paquet == null && !(logger = Logging.getLogger(paquet = (separator = classname.lastIndexOf(46)) >= '\u0001' ? classname.substring(0, separator - '\u0001') : "")).isLoggable(level)) {
                    return false;
                }
                if (classe == null) {
                    classe = classname;
                }
                if (method != null) break;
                method = methodName;
                break;
            }
            if (logger == null && !(logger = Logging.getLogger("global")).isLoggable(level)) {
                return false;
            }
        }
        StringBuilder buffer = new StringBuilder(256).append(Classes.getShortClassName(error));
        String message = error.getMessage();
        if (message != null) {
            buffer.append(": ").append(message);
        }
        message = buffer.toString();
        message = Exceptions.formatChainedMessages(null, message, error);
        LogRecord record = new LogRecord(level, message);
        if (classe != null) {
            record.setSourceClassName(classe);
        }
        if (method != null) {
            record.setSourceMethodName(method);
        }
        if (level.intValue() >= 600) {
            record.setThrown(error);
        }
        record.setLoggerName(logger.getName());
        logger.log(record);
        return true;
    }

    static boolean configurationException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.CONFIG);
    }

    public static boolean recoverableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINE);
    }

    public static boolean severeException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.SEVERE);
    }

    static {
        LoggerFactory factory = null;
        for (LoggerFactory found : ServiceLoader.load(LoggerFactory.class)) {
            if (factory == null) {
                factory = found;
                continue;
            }
            factory = new DualLoggerFactory(factory, found);
        }
        Logging.factory = factory;
    }
}

