/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.util.ArgumentChecks;

public final class PerformanceLevel
extends Level {
    private static final long serialVersionUID = -6547125008284983701L;
    public static final PerformanceLevel PERFORMANCE = new PerformanceLevel("PERFORMANCE", 600, 0L);
    public static final PerformanceLevel SLOW = new PerformanceLevel("SLOW", 610, 100000000L);
    public static final PerformanceLevel SLOWER = new PerformanceLevel("SLOWER", 620, 1000000000L);
    public static final PerformanceLevel SLOWEST = new PerformanceLevel("SLOWEST", 630, 5000000000L);
    private volatile long minDuration;

    private PerformanceLevel(String name, int value, long duration) {
        super(name, value);
        this.minDuration = duration;
    }

    public static PerformanceLevel forDuration(long duration, TimeUnit unit) {
        if ((duration = unit.toNanos(duration)) >= PerformanceLevel.SLOWER.minDuration) {
            return duration >= PerformanceLevel.SLOWEST.minDuration ? SLOWEST : SLOWER;
        }
        return duration >= PerformanceLevel.SLOW.minDuration ? SLOW : PERFORMANCE;
    }

    public long getMinDuration(TimeUnit unit) {
        return unit.convert(this.minDuration, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinDuration(long duration, TimeUnit unit) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("duration", duration);
        duration = unit.toNanos(duration);
        int value = this.intValue();
        Class<PerformanceLevel> clazz = PerformanceLevel.class;
        synchronized (PerformanceLevel.class) {
            switch (value) {
                default: {
                    throw new AssertionError(this);
                }
                case 600: {
                    if (duration > PerformanceLevel.SLOW.minDuration) {
                        PerformanceLevel.SLOW.minDuration = duration;
                    }
                }
                case 610: {
                    if (duration > PerformanceLevel.SLOWER.minDuration) {
                        PerformanceLevel.SLOWER.minDuration = duration;
                    }
                }
                case 620: {
                    if (duration <= PerformanceLevel.SLOWEST.minDuration) break;
                    PerformanceLevel.SLOWEST.minDuration = duration;
                }
                case 630: 
            }
            switch (value) {
                default: {
                    throw new AssertionError(this);
                }
                case 630: {
                    if (duration < PerformanceLevel.SLOWER.minDuration) {
                        PerformanceLevel.SLOWER.minDuration = duration;
                    }
                }
                case 620: {
                    if (duration < PerformanceLevel.SLOW.minDuration) {
                        PerformanceLevel.SLOW.minDuration = duration;
                    }
                }
                case 610: {
                    this.minDuration = duration;
                }
                case 600: 
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }
}

