/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.QuietLogRecord;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;

public class WarningListeners<S>
implements Localized {
    private final S source;
    private WarningListener<? super S>[] listeners;

    WarningListeners() {
        this.source = null;
    }

    public WarningListeners(S source) {
        ArgumentChecks.ensureNonNull("source", source);
        this.source = source;
    }

    @Override
    public Locale getLocale() {
        return this.source instanceof Localized ? ((Localized)this.source).getLocale() : null;
    }

    public Logger getLogger() {
        return Logging.getLogger(this.source.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(LogRecord record) {
        WarningListener<? super S>[] warningListenerArray = this;
        synchronized (this) {
            WarningListener<? super S>[] current = this.listeners;
            // ** MonitorExit[warningListenerArray] (shouldn't be in output)
            if (current != null) {
                for (WarningListener<S> warningListener : this.listeners) {
                    warningListener.warningOccured(this.source, record);
                }
            } else {
                Logger logger = this.getLogger();
                record.setLoggerName(logger.getName());
                if (record instanceof QuietLogRecord) {
                    ((QuietLogRecord)record).clearThrown();
                }
                logger.log(record);
            }
            return;
        }
    }

    public void warning(String message, Exception exception) {
        LogRecord record;
        StackTraceElement[] trace;
        if (exception != null) {
            trace = exception.getStackTrace();
            message = Exceptions.formatChainedMessages(this.getLocale(), message, exception);
            if (message == null) {
                message = exception.toString();
            }
            record = new QuietLogRecord(message, exception);
        } else {
            ArgumentChecks.ensureNonEmpty("message", message);
            trace = Thread.currentThread().getStackTrace();
            record = new LogRecord(Level.WARNING, message);
        }
        for (StackTraceElement e : trace) {
            if (!WarningListeners.isPublic(e)) continue;
            record.setSourceClassName(e.getClassName());
            record.setSourceMethodName(e.getMethodName());
            break;
        }
        this.warning(record);
    }

    private static boolean isPublic(StackTraceElement e) {
        String classname = e.getClassName();
        return !classname.equals("org.apache.sis.util.logging.WarningListeners") && !classname.contains(".internal.") && !classname.startsWith("java") && classname.indexOf(36) < 0 && e.getMethodName().indexOf(36) < 0;
    }

    public synchronized void addWarningListener(WarningListener<? super S> listener) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("listener", listener);
        WarningListener<? super S>[] current = this.listeners;
        int length = current != null ? current.length : 0;
        WarningListener[] copy = new WarningListener[length + 1];
        for (int i = 0; i < length; ++i) {
            WarningListener<? super S> c = current[i];
            if (c == listener) {
                throw new IllegalArgumentException(Errors.format((short)19, listener));
            }
            copy[i] = c;
        }
        copy[length] = listener;
        this.listeners = copy;
    }

    public synchronized void removeWarningListener(WarningListener<? super S> listener) throws NoSuchElementException {
        ArgumentChecks.ensureNonNull("listener", listener);
        WarningListener<? super S>[] current = this.listeners;
        if (current != null) {
            for (int i = 0; i < current.length; ++i) {
                if (current[i] != listener) continue;
                if (current.length == 1) {
                    this.listeners = null;
                } else {
                    WarningListener[] copy = new WarningListener[current.length - 1];
                    System.arraycopy(current, 0, copy, 0, i);
                    System.arraycopy(current, i + 1, copy, i, copy.length - i);
                    this.listeners = copy;
                }
                return;
            }
        }
        throw new NoSuchElementException(Errors.format((short)70, listener));
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null;
    }
}

