/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;

class KeyConstants {
    private final Class<?> keysClass;
    private transient String[] keys;

    protected KeyConstants() {
        this.keysClass = this.getClass();
    }

    KeyConstants(Class<?> keysClass) {
        this.keysClass = keysClass;
    }

    final synchronized String[] getKeyNames() {
        if (this.keys == null) {
            String[] names;
            int length = 0;
            try {
                Field[] fields = this.keysClass.getFields();
                names = new String[fields.length];
                for (Field field : fields) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Short.TYPE) continue;
                    int index = (Short)field.get(null) & 0xFFFF;
                    if (index >= length && (length = index + 1) > names.length) {
                        names = Arrays.copyOf(names, length * 2);
                    }
                    names[index] = field.getName();
                }
            }
            catch (IllegalAccessException e) {
                names = CharSequences.EMPTY_ARRAY;
            }
            this.keys = ArraysExt.resize(names, length);
        }
        return this.keys;
    }

    final String getKeyName(short index) {
        String key;
        int i = index & 0xFFFF;
        String[] keys = this.getKeyNames();
        if (i < keys.length && (key = keys[i]) != null) {
            return key;
        }
        return String.valueOf(index);
    }

    final short getKeyValue(String name) throws NoSuchFieldException, IllegalAccessException {
        return (Short)this.keysClass.getField(name).get(null);
    }
}

