/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.AbstractInternationalString;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;

abstract class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -3910920973710535739L;
    private transient short key;
    private final boolean hasArguments;
    private final Object arguments;

    ResourceInternationalString(short key) {
        this.key = key;
        this.hasArguments = false;
        this.arguments = null;
    }

    ResourceInternationalString(short key, Object arguments) {
        this.key = key;
        this.hasArguments = true;
        this.arguments = arguments;
    }

    abstract KeyConstants getKeyConstants();

    abstract IndexedResourceBundle getBundle(Locale var1);

    @Override
    public final String toString(Locale locale) throws MissingResourceException {
        IndexedResourceBundle resources = this.getBundle(locale);
        return this.hasArguments ? resources.getString(this.key, this.arguments) : resources.getString(this.key);
    }

    public final boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ResourceInternationalString that = (ResourceInternationalString)object;
        return this.key == that.key && this.hasArguments == that.hasArguments && Objects.deepEquals(this.arguments, that.arguments);
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.key + 31 * Utilities.deepHashCode(this.arguments) ^ 0x695BD3C5;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.getKeyConstants().getKeyName(this.key));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.key = this.getKeyConstants().getKeyValue(in.readUTF());
        }
        catch (Exception cause) {
            InvalidObjectException e = new InvalidObjectException(cause.toString());
            e.initCause(cause);
            throw e;
        }
    }
}

