/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Vocabulary
extends IndexedResourceBundle {
    Vocabulary(URL resources) {
        super(resources);
    }

    @Override
    final KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Vocabulary getResources(Locale locale) throws MissingResourceException {
        return Vocabulary.getBundle(Vocabulary.class, locale);
    }

    public static Vocabulary getResources(Map<?, ?> properties) throws MissingResourceException {
        return Vocabulary.getResources(Vocabulary.getLocale(properties));
    }

    public static String format(short key) throws MissingResourceException {
        return Vocabulary.getResources((Locale)null).getString(key);
    }

    public static InternationalString formatInternational(short key) {
        return new International(key);
    }

    public static InternationalString formatInternational(short key, Object arg) {
        return new International(key, arg);
    }

    public static InternationalString formatInternational(short key, Object ... args) {
        return new International(key, args);
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = -5423999784169092823L;

        International(short key) {
            super(key);
        }

        International(short key, Object args) {
            super(key, args);
        }

        @Override
        KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        IndexedResourceBundle getBundle(Locale locale) {
            return Vocabulary.getResources(locale);
        }
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short Accuracy = 109;
        public static final short Aliases = 74;
        public static final short Angle = 0;
        public static final short AngularDegrees = 1;
        public static final short AngularMinutes = 2;
        public static final short AngularSeconds = 3;
        public static final short Attributes = 4;
        public static final short AxisChanges = 98;
        public static final short BarometricAltitude = 5;
        public static final short Cardinality = 76;
        public static final short CausedBy_1 = 107;
        public static final short CharacterEncoding = 6;
        public static final short Characteristics = 85;
        public static final short Classpath = 7;
        public static final short Code_1 = 8;
        public static final short Commands = 9;
        public static final short ConstantPressureSurface = 19;
        public static final short Container = 92;
        public static final short Correlation = 83;
        public static final short CurrentDateTime = 10;
        public static final short CurrentDirectory = 11;
        public static final short CycleOmitted = 12;
        public static final short DataBase = 96;
        public static final short DataDirectory = 88;
        public static final short Datum = 99;
        public static final short DatumShift = 100;
        public static final short DaylightTime = 13;
        public static final short DefaultValue = 71;
        public static final short DerivedFrom_1 = 108;
        public static final short Description = 75;
        public static final short Destination = 14;
        public static final short Details = 110;
        public static final short Dimensions = 15;
        public static final short Directory = 16;
        public static final short DittoMark = 82;
        public static final short Domain = 113;
        public static final short DublinJulian = 17;
        public static final short Ellipsoid = 70;
        public static final short EllipsoidChange = 101;
        public static final short EllipsoidalHeight = 18;
        public static final short Geocentric = 102;
        public static final short GeocentricConversion = 103;
        public static final short GeocentricRadius = 104;
        public static final short GeodeticDataset = 95;
        public static final short Height = 69;
        public static final short Identifier = 20;
        public static final short Identity = 105;
        public static final short Implementation = 21;
        public static final short InBetweenWords = 87;
        public static final short Index = 22;
        public static final short Invalid = 89;
        public static final short InverseOperation = 106;
        public static final short JavaExtensions = 23;
        public static final short JavaHome = 24;
        public static final short Julian = 25;
        public static final short Latitude = 26;
        public static final short Legend = 97;
        public static final short Level = 94;
        public static final short Libraries = 27;
        public static final short LocalConfiguration = 28;
        public static final short Locale = 29;
        public static final short Localization = 30;
        public static final short Logging = 31;
        public static final short Longitude = 32;
        public static final short Mandatory = 77;
        public static final short MaximumValue = 33;
        public static final short MeanValue = 34;
        public static final short Methods = 111;
        public static final short MinimumValue = 35;
        public static final short ModifiedJulian = 36;
        public static final short Name = 37;
        public static final short None = 91;
        public static final short Note = 114;
        public static final short NumberOfNaN = 38;
        public static final short NumberOfValues = 39;
        public static final short Obligation = 78;
        public static final short Of_3 = 40;
        public static final short Offset = 41;
        public static final short OperatingSystem = 42;
        public static final short Operations = 112;
        public static final short Optional = 79;
        public static final short Options = 43;
        public static final short OtherSurface = 44;
        public static final short Others = 45;
        public static final short Paths = 46;
        public static final short Quoted_1 = 86;
        public static final short RemoteConfiguration = 93;
        public static final short Root = 47;
        public static final short RootMeanSquare = 48;
        public static final short Scale = 49;
        public static final short Source = 50;
        public static final short StandardDeviation = 51;
        public static final short SupersededBy_1 = 84;
        public static final short Temporal = 66;
        public static final short TemporaryFiles = 52;
        public static final short Time = 67;
        public static final short Time_1 = 53;
        public static final short Timezone = 54;
        public static final short Transformation = 80;
        public static final short TransformationAccuracy = 81;
        public static final short TruncatedJulian = 55;
        public static final short Type = 56;
        public static final short UnavailableContent = 57;
        public static final short Units = 72;
        public static final short Unnamed = 65;
        public static final short Untitled = 58;
        public static final short UserHome = 59;
        public static final short Value = 60;
        public static final short ValueDomain = 73;
        public static final short Variables = 61;
        public static final short Version_2 = 62;
        public static final short Versions = 63;
        public static final short Vertical = 68;
        public static final short Warnings = 90;
        public static final short World = 64;

        private Keys() {
        }
    }
}

