/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.sis.xml.FilterVersion;

final class FilteredNamespaces
implements NamespaceContext {
    private final NamespaceContext context;
    private final Map<String, String> toView;
    private final Map<String, String> toImpl;

    FilteredNamespaces(NamespaceContext context, FilterVersion version, boolean inverse) {
        this.context = context;
        if (!inverse) {
            this.toView = version.toView;
            this.toImpl = version.toImpl;
        } else {
            this.toView = version.toImpl;
            this.toImpl = version.toView;
        }
    }

    NamespaceContext inverse(FilterVersion version) {
        if (this.toView == version.toView && this.toImpl == version.toImpl) {
            return this;
        }
        return new FilteredNamespaces(this, version, true);
    }

    private String toView(String uri) {
        String replacement = this.toView.get(uri);
        return replacement != null ? replacement : uri;
    }

    private String toImpl(String uri) {
        String replacement = this.toImpl.get(uri);
        return replacement != null ? replacement : uri;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.toView(this.context.getNamespaceURI(prefix));
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.context.getPrefix(this.toImpl(namespaceURI));
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.context.getPrefixes(this.toImpl(namespaceURI));
    }
}

