/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredNamespaces;

final class FilteredStreamReader
extends StreamReaderDelegate {
    private final FilterVersion version;

    FilteredStreamReader(XMLStreamReader in, FilterVersion version) {
        super(in);
        this.version = version;
    }

    private String toView(String uri) {
        String replacement = this.version.toView.get(uri);
        return replacement != null ? replacement : uri;
    }

    private String toImpl(String uri) {
        String replacement = this.version.toImpl.get(uri);
        return replacement != null ? replacement : uri;
    }

    private QName toImpl(QName name) {
        String namespaceURI = name.getNamespaceURI();
        String replacement = this.toImpl(namespaceURI);
        if (replacement != namespaceURI) {
            name = new QName(namespaceURI, name.getLocalPart(), name.getPrefix());
        }
        return name;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        super.require(type, this.toView(namespaceURI), localName);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new FilteredNamespaces(super.getNamespaceContext(), this.version, true);
    }

    @Override
    public QName getName() {
        return this.toImpl(super.getName());
    }

    @Override
    public QName getAttributeName(int index) {
        return this.toImpl(super.getAttributeName(index));
    }

    @Override
    public String getNamespaceURI() {
        return this.toImpl(super.getNamespaceURI());
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.toImpl(super.getNamespaceURI(index));
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.toImpl(super.getNamespaceURI(prefix));
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.toImpl(super.getAttributeNamespace(index));
    }

    @Override
    public String getAttributeValue(String namespaceUri, String localName) {
        return super.getAttributeValue(this.toView(namespaceUri), localName);
    }
}

