/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredNamespaces;

final class FilteredStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter out;
    private final FilterVersion version;

    FilteredStreamWriter(XMLStreamWriter out, FilterVersion version) {
        this.out = out;
        this.version = version;
    }

    private String toView(String uri) {
        String replacement = this.version.toView.get(uri);
        return replacement != null ? replacement : uri;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.out.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.out.writeStartElement(this.toView(namespaceURI), localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.out.writeStartElement(prefix, localName, this.toView(namespaceURI));
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.out.writeEmptyElement(this.toView(namespaceURI), localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.out.writeEmptyElement(prefix, localName, this.toView(namespaceURI));
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.out.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.out.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.out.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.out.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.out.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.out.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.out.writeAttribute(prefix, this.toView(namespaceURI), localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.out.writeAttribute(this.toView(namespaceURI), localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.out.writeNamespace(prefix, this.toView(namespaceURI));
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.out.writeDefaultNamespace(this.toView(namespaceURI));
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.out.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.out.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.out.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.out.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.out.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.out.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.out.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.out.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.out.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.out.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.out.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.out.getPrefix(this.toView(uri));
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.out.setPrefix(prefix, this.toView(uri));
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.out.setDefaultNamespace(this.toView(uri));
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        context = context instanceof FilteredNamespaces ? ((FilteredNamespaces)context).inverse(this.version) : new FilteredNamespaces(context, this.version, true);
        this.out.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new FilteredNamespaces(this.out.getNamespaceContext(), this.version, false);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.out.getProperty(name);
    }
}

