/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;

public final class Namespaces
extends Static {
    public static final String GCO = "http://www.isotc211.org/2005/gco";
    public static final String GFC = "http://www.isotc211.org/2005/gfc";
    public static final String GMD = "http://www.isotc211.org/2005/gmd";
    public static final String GMI = "http://www.isotc211.org/2005/gmi";
    public static final String SRV = "http://www.isotc211.org/2005/srv";
    public static final String GTS = "http://www.isotc211.org/2005/gts";
    public static final String GMX = "http://www.isotc211.org/2005/gmx";
    public static final String GML = "http://www.opengis.net/gml/3.2";
    public static final String CSW = "http://www.opengis.net/cat/csw/2.0.2";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XLINK = "http://www.w3.org/1999/xlink";
    private static final String[] GENERIC_URLS = new String[]{"http://www.isotc211.org/2005/", "http://www.opengis.net/", "http://www.w3.org/1999/", "http://www.cnig.gouv.fr/2005/", "http://purl.org/"};
    private static final Map<String, String> SPECIFIC_URLS;

    private Namespaces() {
    }

    public static String getPreferredPrefix(String namespace, String defaultValue) {
        ArgumentChecks.ensureNonNull("namespace", namespace);
        String prefix = SPECIFIC_URLS.get(namespace);
        if (prefix != null) {
            return prefix;
        }
        namespace = namespace.toLowerCase(Locale.ROOT);
        for (String baseURL : GENERIC_URLS) {
            if (!namespace.startsWith(baseURL)) continue;
            int startAt = baseURL.length();
            int endAt = namespace.indexOf(47, startAt);
            prefix = endAt >= 0 ? namespace.substring(startAt, endAt) : namespace.substring(startAt);
            return prefix;
        }
        return defaultValue;
    }

    static {
        HashMap<String, String> p = new HashMap<String, String>(40);
        p.put("http://www.w3.org/2001/XMLSchema", "xsd");
        p.put(XSI, "xsi");
        p.put("http://www.w3.org/2004/02/skos/core#", "skos");
        p.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        p.put("http://www.w3.org/1998/Math/MathML", "mml");
        p.put("http://www.opengis.net/sensorML/1.0", "sml1");
        p.put("http://www.opengis.net/sensorML/1.0.1", "sml");
        p.put("http://www.opengis.net/swe/1.0", "swe1");
        p.put(CSW, "csw");
        p.put("http://www.opengis.net/cat/wrs/1.0", "wrs");
        p.put("http://www.opengis.net/cat/wrs", "wrs09");
        p.put("http://www.opengis.net/ows-6/utds/0.3", "utds");
        p.put("http://www.opengis.net/citygml/1.0", "core");
        p.put("http://www.opengis.net/citygml/building/1.0", "build");
        p.put("http://www.opengis.net/citygml/cityfurniture/1.0", "furniture");
        p.put("http://www.opengis.net/citygml/transportation/1.0", "tr");
        p.put("http://www.purl.org/dc/elements/1.1/", "dc2");
        p.put("http://www.purl.org/dc/terms/", "dct2");
        p.put("http://purl.org/dc/terms/", "dct");
        p.put("http://www.inspire.org", "ins");
        p.put("http://inspira.europa.eu/networkservice/view/1.0", "inspire_vs");
        p.put("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", "xal");
        p.put("urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0", "rim");
        p.put("urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.5", "rim25");
        p.put("urn:oasis:names:tc:xacml:2.0:context:schema:os", "xacml-context");
        p.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "xacml-policy");
        p.put("urn:us:gov:ic:ism:v2", "icism");
        SPECIFIC_URLS = p;
    }
}

