/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.LegacyNamespaces;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.ValueConverter;

abstract class Pooled {
    private static final String[] SCHEMA_KEYS = new String[]{"gmd"};
    static final String ENDORSED_PREFIX = "com.sun.xml.bind.";
    private final boolean internal;
    final Map<Object, Object> initialProperties;
    private int bitMasks;
    private Locale locale;
    private TimeZone timezone;
    private Map<String, String> schemas;
    private byte xmlnsReplaceCode;
    private Version versionGML;
    private ReferenceResolver resolver;
    private ValueConverter converter;
    private WarningListener<?> warningListener;
    volatile long resetTime;

    Pooled(boolean internal) {
        this.internal = internal;
        this.initialProperties = new LinkedHashMap<Object, Object>();
    }

    Pooled(Pooled template) {
        this.initialProperties = new LinkedHashMap<Object, Object>();
        this.internal = template.internal;
    }

    final void initialize(Pooled template) throws JAXBException {
        this.reset(template);
        for (Map.Entry<Object, Object> entry : template.initialProperties.entrySet()) {
            this.setStandardProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public final void reset(Pooled template) throws JAXBException {
        for (Map.Entry<Object, Object> entry : this.initialProperties.entrySet()) {
            this.reset(entry.getKey(), entry.getValue());
        }
        this.initialProperties.clear();
        this.bitMasks = template.bitMasks;
        this.locale = template.locale;
        this.timezone = template.timezone;
        this.schemas = template.schemas;
        this.xmlnsReplaceCode = template.xmlnsReplaceCode;
        this.versionGML = template.versionGML;
        this.resolver = template.resolver;
        this.converter = template.converter;
        this.warningListener = template.warningListener;
        this.resetTime = System.nanoTime();
        if (this instanceof Marshaller) {
            this.bitMasks |= 1;
        }
    }

    protected abstract void reset(Object var1, Object var2) throws JAXBException;

    final FilterVersion getFilterVersion() {
        switch (this.xmlnsReplaceCode) {
            case 0: {
                if (this.versionGML == null || this.versionGML.compareTo(LegacyNamespaces.VERSION_3_2_1) >= 0) break;
                return FilterVersion.GML31;
            }
            case 1: {
                if ((this.bitMasks & 1) != 0) break;
                return FilterVersion.ALL;
            }
        }
        return null;
    }

    final boolean isPropertySaved(Class<?> key) {
        return this.initialProperties.containsKey(key);
    }

    final <E> void saveProperty(Class<E> type, E value) {
        if (this.initialProperties.put(type, value) != null) {
            throw new ConcurrentModificationException(Errors.format((short)108, type.getInterfaces()[0].getSimpleName() + ".get" + type.getSimpleName()));
        }
    }

    private String convertPropertyKey(String key) {
        if (this.internal && key.startsWith(ENDORSED_PREFIX)) {
            StringBuilder buffer = new StringBuilder(key.length() + 10);
            key = buffer.append("com.sun.xml.internal.bind.").append(key, ENDORSED_PREFIX.length(), key.length()).toString();
        }
        return key;
    }

    public final void setProperty(String name, Object value) throws PropertyException {
        try {
            if (name.equals("org.apache.sis.xml.locale")) {
                this.locale = value instanceof CharSequence ? Locales.parse(value.toString()) : (Locale)value;
                return;
            }
            if (name.equals("org.apache.sis.xml.timezone")) {
                this.timezone = value instanceof CharSequence ? TimeZone.getTimeZone(value.toString()) : (TimeZone)value;
                return;
            }
            if (name.equals("org.apache.sis.xml.schemas")) {
                Map map = (Map)value;
                Map<String, String> copy = null;
                if (map != null) {
                    copy = new HashMap(4);
                    for (String key : SCHEMA_KEYS) {
                        Object schema = map.get(key);
                        if (schema == null) continue;
                        if (!(schema instanceof String)) {
                            throw new PropertyException(Errors.format((short)40, name + "[\"" + key + "\"]", value.getClass()));
                        }
                        copy.put(key, (String)schema);
                    }
                    copy = CollectionsExt.unmodifiableOrCopy(copy);
                }
                this.schemas = copy;
                return;
            }
            if (name.equals("org.apache.sis.gml.version")) {
                this.versionGML = value instanceof CharSequence ? new Version(value.toString()) : (Version)value;
                return;
            }
            if (name.equals("org.apache.sis.xml.resolver")) {
                this.resolver = (ReferenceResolver)value;
                return;
            }
            if (name.equals("org.apache.sis.xml.converter")) {
                this.converter = (ValueConverter)value;
                return;
            }
            if (name.equals("org.apache.sis.xml.stringSubstitutes")) {
                this.bitMasks &= 0xFFFFFFE1;
                if (value != null) {
                    for (CharSequence substitute : (CharSequence[])value) {
                        if (CharSequences.equalsIgnoreCase(substitute, "language")) {
                            this.bitMasks |= 2;
                            continue;
                        }
                        if (CharSequences.equalsIgnoreCase(substitute, "country")) {
                            this.bitMasks |= 4;
                            continue;
                        }
                        if (CharSequences.equalsIgnoreCase(substitute, "filename")) {
                            this.bitMasks |= 8;
                            continue;
                        }
                        if (!CharSequences.equalsIgnoreCase(substitute, "mimetype")) continue;
                        this.bitMasks |= 0x10;
                    }
                }
                return;
            }
            if (name.equals("org.apache.sis.xml.warningListener")) {
                this.warningListener = (WarningListener)value;
                return;
            }
            if (name.equals("org.apache.sis.xml.applyNamespaceReplacements")) {
                this.xmlnsReplaceCode = 0;
                if (value != null) {
                    this.xmlnsReplaceCode = (byte)((Boolean)value != false ? 1 : 2);
                }
                return;
            }
        }
        catch (RuntimeException e) {
            throw new PropertyException(Errors.format((short)40, name, value.getClass()), (Throwable)e);
        }
        name = this.convertPropertyKey(name);
        if (!this.initialProperties.containsKey(name) && this.initialProperties.put(name, this.getStandardProperty(name)) != null) {
            throw new ConcurrentModificationException(name);
        }
        this.setStandardProperty(name, value);
    }

    public final Object getProperty(String name) throws PropertyException {
        if (name.equals("org.apache.sis.xml.locale")) {
            return this.locale;
        }
        if (name.equals("org.apache.sis.xml.timezone")) {
            return this.timezone;
        }
        if (name.equals("org.apache.sis.xml.schemas")) {
            return this.schemas;
        }
        if (name.equals("org.apache.sis.gml.version")) {
            return this.versionGML;
        }
        if (name.equals("org.apache.sis.xml.resolver")) {
            return this.resolver;
        }
        if (name.equals("org.apache.sis.xml.converter")) {
            return this.converter;
        }
        if (name.equals("org.apache.sis.xml.warningListener")) {
            return this.warningListener;
        }
        if (name.equals("org.apache.sis.xml.stringSubstitutes")) {
            int n = 0;
            String[] substitutes = new String[4];
            if ((this.bitMasks & 2) != 0) {
                substitutes[n++] = "language";
            }
            if ((this.bitMasks & 4) != 0) {
                substitutes[n++] = "country";
            }
            if ((this.bitMasks & 8) != 0) {
                substitutes[n++] = "filename";
            }
            if ((this.bitMasks & 0x10) != 0) {
                substitutes[n++] = "mimetype";
            }
            return n != 0 ? ArraysExt.resize(substitutes, n) : null;
        }
        if (name.equals("org.apache.sis.xml.applyNamespaceReplacements")) {
            switch (this.xmlnsReplaceCode) {
                case 1: {
                    return Boolean.TRUE;
                }
                case 2: {
                    return Boolean.FALSE;
                }
            }
            return null;
        }
        return this.getStandardProperty(this.convertPropertyKey(name));
    }

    abstract void setStandardProperty(String var1, Object var2) throws PropertyException;

    abstract Object getStandardProperty(String var1) throws PropertyException;

    public final void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        if (!this.isPropertySaved(type)) {
            this.saveProperty(type, this.getAdapter(type));
        }
    }

    public abstract <A extends XmlAdapter> A getAdapter(Class<A> var1);

    public void setSchema(Schema schema) {
        if (!this.isPropertySaved(Schema.class)) {
            this.saveProperty(Schema.class, this.getSchema());
        }
    }

    public abstract Schema getSchema();

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        if (!this.initialProperties.containsKey(ValidationEventHandler.class)) {
            this.saveProperty(ValidationEventHandler.class, this.getEventHandler());
        }
    }

    public abstract ValidationEventHandler getEventHandler() throws JAXBException;

    final Context begin() {
        return new Context(this.bitMasks, this.locale, this.timezone, this.schemas, this.versionGML, this.resolver, this.converter, this.warningListener);
    }
}

