/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.system.XMLInputFactory;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredStreamReader;
import org.apache.sis.xml.Pooled;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

final class PooledUnmarshaller
extends Pooled
implements Unmarshaller {
    private final Unmarshaller unmarshaller;

    PooledUnmarshaller(Unmarshaller unmarshaller, Pooled template) throws JAXBException {
        super(template);
        this.unmarshaller = unmarshaller;
        this.initialize(template);
    }

    @Override
    protected void reset(Object key, Object value) throws JAXBException {
        if (key instanceof String) {
            this.unmarshaller.setProperty((String)key, value);
        } else if (key == AttachmentUnmarshaller.class) {
            this.unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)value);
        } else if (key == Schema.class) {
            this.unmarshaller.setSchema((Schema)value);
        } else if (key == Unmarshaller.Listener.class) {
            this.unmarshaller.setListener((Unmarshaller.Listener)value);
        } else if (key == ValidationEventHandler.class) {
            this.unmarshaller.setEventHandler((ValidationEventHandler)value);
        } else if (key == Boolean.class) {
            this.unmarshaller.setValidating(((Boolean)value).booleanValue());
        } else {
            this.unmarshaller.setAdapter((Class)key, (XmlAdapter)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshal(XMLStreamReader input, FilterVersion version) throws XMLStreamException, JAXBException {
        Object object;
        input = new FilteredStreamReader(input, version);
        Context context = this.begin();
        try {
            object = this.unmarshaller.unmarshal(input);
        }
        finally {
            context.finish();
        }
        input.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> JAXBElement<T> unmarshal(XMLStreamReader input, FilterVersion version, Class<T> declaredType) throws XMLStreamException, JAXBException {
        JAXBElement object;
        input = new FilteredStreamReader(input, version);
        Context context = this.begin();
        try {
            object = this.unmarshaller.unmarshal(input, declaredType);
        }
        finally {
            context.finish();
        }
        input.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(InputStream input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(URL input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            Object object;
            InputStream s = input.openStream();
            try {
                object = this.unmarshal(XMLInputFactory.createXMLStreamReader(s), version);
            }
            catch (Throwable throwable) {
                try {
                    s.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JAXBException((Throwable)e);
                }
            }
            s.close();
            return object;
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(File input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            Object object;
            BufferedInputStream s = new BufferedInputStream(new FileInputStream(input));
            try {
                object = this.unmarshal(XMLInputFactory.createXMLStreamReader(s), version);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)s).close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JAXBException((Throwable)e);
                }
            }
            ((InputStream)s).close();
            return object;
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Reader input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(InputSource input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Node input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(Node input, Class<T> declaredType) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version, declaredType);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Source input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(Source input, Class<T> declaredType) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version, declaredType);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(XMLStreamReader input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            input = new FilteredStreamReader(input, version);
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(XMLStreamReader input, Class<T> declaredType) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            input = new FilteredStreamReader(input, version);
        }
        Context context = this.begin();
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(XMLEventReader input) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            Object object = this.unmarshaller.unmarshal(input);
            return object;
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JAXBElement<T> unmarshal(XMLEventReader input, Class<T> declaredType) throws JAXBException {
        FilterVersion version = this.getFilterVersion();
        if (version != null) {
            try {
                return this.unmarshal(XMLInputFactory.createXMLStreamReader(input), version, declaredType);
            }
            catch (XMLStreamException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        Context context = this.begin();
        try {
            JAXBElement jAXBElement = this.unmarshaller.unmarshal(input, declaredType);
            return jAXBElement;
        }
        finally {
            context.finish();
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.unmarshaller.getUnmarshallerHandler();
    }

    @Override
    void setStandardProperty(String name, Object value) throws PropertyException {
        this.unmarshaller.setProperty(name, value);
    }

    @Override
    Object getStandardProperty(String name) throws PropertyException {
        return this.unmarshaller.getProperty(name);
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        super.setAdapter(type, adapter);
        this.unmarshaller.setAdapter(type, adapter);
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.unmarshaller.getAdapter(type);
    }

    @Deprecated
    public void setValidating(boolean validating) throws JAXBException {
        if (!this.isPropertySaved(Boolean.class)) {
            this.saveProperty(Boolean.class, this.unmarshaller.isValidating());
        }
        this.unmarshaller.setValidating(validating);
    }

    @Deprecated
    public boolean isValidating() throws JAXBException {
        return this.unmarshaller.isValidating();
    }

    @Override
    public void setSchema(Schema schema) {
        super.setSchema(schema);
        this.unmarshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.unmarshaller.getSchema();
    }

    @Override
    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        super.setEventHandler(handler);
        this.unmarshaller.setEventHandler(handler);
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.unmarshaller.getEventHandler();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        if (!this.isPropertySaved(AttachmentUnmarshaller.class)) {
            this.saveProperty(AttachmentUnmarshaller.class, this.unmarshaller.getAttachmentUnmarshaller());
        }
        this.unmarshaller.setAttachmentUnmarshaller(au);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.unmarshaller.getAttachmentUnmarshaller();
    }

    public void setListener(Unmarshaller.Listener listener) {
        if (!this.isPropertySaved(Unmarshaller.Listener.class)) {
            this.saveProperty(Unmarshaller.Listener.class, this.unmarshaller.getListener());
        }
        this.unmarshaller.setListener(listener);
    }

    public Unmarshaller.Listener getListener() {
        return this.unmarshaller.getListener();
    }
}

