/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.xml.MarshallerPool;

public final class XML
extends Static {
    public static final String LOCALE = "org.apache.sis.xml.locale";
    public static final String TIMEZONE = "org.apache.sis.xml.timezone";
    public static final String SCHEMAS = "org.apache.sis.xml.schemas";
    public static final String DEFAULT_NAMESPACE = "org.apache.sis.xml.defaultNamespace";
    public static final String GML_VERSION = "org.apache.sis.gml.version";
    public static final String RESOLVER = "org.apache.sis.xml.resolver";
    public static final String CONVERTER = "org.apache.sis.xml.converter";
    public static final String STRING_SUBSTITUTES = "org.apache.sis.xml.stringSubstitutes";
    public static final String WARNING_LISTENER = "org.apache.sis.xml.warningListener";
    private static volatile MarshallerPool POOL;

    private XML() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MarshallerPool getPool() throws JAXBException {
        MarshallerPool pool = POOL;
        if (pool != null) return pool;
        Class<XML> clazz = XML.class;
        synchronized (XML.class) {
            pool = POOL;
            if (pool != null) return pool;
            POOL = pool = new MarshallerPool(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return pool;
        }
    }

    public static String marshal(Object object) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        StringWriter output = new StringWriter();
        MarshallerPool pool = XML.getPool();
        Marshaller marshaller = pool.acquireMarshaller();
        marshaller.marshal(object, (Writer)output);
        pool.recycle(marshaller);
        return output.toString();
    }

    public static void marshal(Object object, OutputStream output) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("output", output);
        MarshallerPool pool = XML.getPool();
        Marshaller marshaller = pool.acquireMarshaller();
        marshaller.marshal(object, output);
        pool.recycle(marshaller);
    }

    public static void marshal(Object object, File output) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("output", output);
        MarshallerPool pool = XML.getPool();
        Marshaller marshaller = pool.acquireMarshaller();
        marshaller.marshal(object, output);
        pool.recycle(marshaller);
    }

    public static void marshal(Object object, Result output, Map<String, ?> properties) throws JAXBException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("output", output);
        MarshallerPool pool = XML.getPool();
        Marshaller marshaller = pool.acquireMarshaller();
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                marshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        marshaller.marshal(object, output);
        pool.recycle(marshaller);
    }

    public static Object unmarshal(String xml) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", xml);
        StringReader in = new StringReader(xml);
        MarshallerPool pool = XML.getPool();
        Unmarshaller unmarshaller = pool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal((Reader)in);
        pool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(InputStream input) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", input);
        MarshallerPool pool = XML.getPool();
        Unmarshaller unmarshaller = pool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(input);
        pool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(URL input) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", input);
        MarshallerPool pool = XML.getPool();
        Unmarshaller unmarshaller = pool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(input);
        pool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(File input) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", input);
        MarshallerPool pool = XML.getPool();
        Unmarshaller unmarshaller = pool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(input);
        pool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(Source input, Map<String, ?> properties) throws JAXBException {
        ArgumentChecks.ensureNonNull("input", input);
        MarshallerPool pool = XML.getPool();
        Unmarshaller unmarshaller = pool.acquireUnmarshaller();
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        Object object = unmarshaller.unmarshal(input);
        pool.recycle(unmarshaller);
        return object;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.util"){

            @Override
            protected void classpathChanged() {
                POOL = null;
            }
        });
    }
}

