/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.metadata;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.spatial.data.sdi.model.metadata.ParameterType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TemplateInvocation {
    @XmlElement(name="templateID")
    private String toInvokeTemplateID;
    @XmlElement(name="parameters")
    private ArrayList<ParameterType> templateParameters;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.templateParameters != null && !this.templateParameters.isEmpty()) {
            for (ParameterType param : this.templateParameters) {
                result = 31 * result + param.hashCode();
            }
        }
        result = 31 * result + (this.toInvokeTemplateID == null ? 0 : this.toInvokeTemplateID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateInvocation other = (TemplateInvocation)obj;
        if (this.templateParameters == null || this.templateParameters.isEmpty()) {
            if (other.templateParameters != null && !other.templateParameters.isEmpty()) {
                return false;
            }
        } else {
            if (this.templateParameters.size() != other.templateParameters.size()) {
                return false;
            }
            if (!other.templateParameters.containsAll(this.templateParameters)) {
                return false;
            }
        }
        return !(this.toInvokeTemplateID == null ? other.toInvokeTemplateID != null : !this.toInvokeTemplateID.equals(other.toInvokeTemplateID));
    }

    public void addParameter(String name, String value) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList();
        }
        this.templateParameters.add(new ParameterType(name, value));
    }

    public String getToInvokeTemplateID() {
        return this.toInvokeTemplateID;
    }

    public ArrayList<ParameterType> getTemplateParameters() {
        return this.templateParameters;
    }

    public void setToInvokeTemplateID(String toInvokeTemplateID) {
        this.toInvokeTemplateID = toInvokeTemplateID;
    }

    public void setTemplateParameters(ArrayList<ParameterType> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public TemplateInvocation() {
    }

    @ConstructorProperties(value={"toInvokeTemplateID", "templateParameters"})
    public TemplateInvocation(String toInvokeTemplateID, ArrayList<ParameterType> templateParameters) {
        this.toInvokeTemplateID = toInvokeTemplateID;
        this.templateParameters = templateParameters;
    }

    public String toString() {
        return "TemplateInvocation(toInvokeTemplateID=" + this.getToInvokeTemplateID() + ", templateParameters=" + this.getTemplateParameters() + ")";
    }
}

