/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.base.MoreObjects;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.ServiceLocatorSupplier;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import org.glassfish.jersey.message.internal.Statuses;

public class ClientResponse
extends InboundMessageContext
implements ClientResponseContext,
ServiceLocatorSupplier {
    private Response.StatusType status;
    private final ClientRequest requestContext;
    private URI resolvedUri;

    public ClientResponse(final ClientRequest requestContext, final Response response) {
        this(response.getStatusInfo(), requestContext);
        this.headers(OutboundJaxrsResponse.from(response).getContext().getStringHeaders());
        final Object entity = response.getEntity();
        if (entity != null) {
            InputStream entityStream = new InputStream(){
                private ByteArrayInputStream byteArrayInputStream = null;

                @Override
                public int read() throws IOException {
                    if (this.byteArrayInputStream == null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStream stream = null;
                        try {
                            try {
                                stream = requestContext.getWorkers().writeTo(entity, entity.getClass(), null, null, response.getMediaType(), response.getMetadata(), requestContext.getPropertiesDelegate(), baos, Collections.<WriterInterceptor>emptyList());
                            }
                            finally {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    }
                    return this.byteArrayInputStream.read();
                }
            };
            this.setEntityStream(entityStream);
        }
    }

    public ClientResponse(Response.StatusType status, ClientRequest requestContext) {
        this(status, requestContext, requestContext.getUri());
    }

    public ClientResponse(Response.StatusType status, ClientRequest requestContext, URI resolvedRequestUri) {
        this.status = status;
        this.resolvedUri = resolvedRequestUri;
        this.requestContext = requestContext;
        this.setWorkers(requestContext.getWorkers());
    }

    @Override
    public int getStatus() {
        return this.status.getStatusCode();
    }

    @Override
    public void setStatus(int code) {
        this.status = Statuses.from(code);
    }

    @Override
    public void setStatusInfo(Response.StatusType status) {
        if (status == null) {
            throw new NullPointerException(LocalizationMessages.CLIENT_RESPONSE_STATUS_NULL());
        }
        this.status = status;
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public URI getResolvedRequestUri() {
        return this.resolvedUri;
    }

    public void setResolvedRequestUri(URI uri) {
        if (uri == null) {
            throw new NullPointerException(LocalizationMessages.CLIENT_RESPONSE_RESOLVED_URI_NULL());
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException(LocalizationMessages.CLIENT_RESPONSE_RESOLVED_URI_NOT_ABSOLUTE());
        }
        this.resolvedUri = uri;
    }

    public ClientRequest getRequestContext() {
        return this.requestContext;
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return super.getResponseCookies();
    }

    @Override
    public Set<Link> getLinks() {
        return Sets.newHashSet(Collections2.transform(super.getLinks(), new Function<Link, Link>(){

            @Override
            public Link apply(Link link) {
                if (link.getUri().isAbsolute()) {
                    return link;
                }
                return Link.fromLink(link).baseUri(ClientResponse.this.getResolvedRequestUri()).build(new Object[0]);
            }
        }));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.requestContext.getMethod()).add("uri", (Object)this.requestContext.getUri()).add("status", this.status.getStatusCode()).add("reason", (Object)this.status.getReasonPhrase()).toString();
    }

    public Object getEntity() throws IllegalStateException {
        return this.getEntityStream();
    }

    public <T> T readEntity(Class<T> entityType) throws ProcessingException, IllegalStateException {
        return this.readEntity(entityType, this.requestContext.getPropertiesDelegate());
    }

    public <T> T readEntity(GenericType<T> entityType) throws ProcessingException, IllegalStateException {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), this.requestContext.getPropertiesDelegate());
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) throws ProcessingException, IllegalStateException {
        return this.readEntity(entityType, annotations, this.requestContext.getPropertiesDelegate());
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) throws ProcessingException, IllegalStateException {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), annotations, this.requestContext.getPropertiesDelegate());
    }

    @Override
    public ServiceLocator getServiceLocator() {
        return this.getRequestContext().getServiceLocator();
    }

    @Override
    protected Iterable<ReaderInterceptor> getReaderInterceptors() {
        return this.requestContext.getReaderInterceptors();
    }
}

