/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import jersey.repackaged.com.google.common.base.Objects;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.process.internal.RequestScoped;

@Singleton
public class RequestScope
implements Context<RequestScoped> {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(RequestScope.class.getName()), Level.FINEST);
    private ThreadLocal<Instance> currentScopeInstance = new ThreadLocal();

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Instance instance = this.current();
        U retVal = instance.get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            instance.put(activeDescriptor, retVal);
        }
        return retVal;
    }

    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        Instance instance = this.current();
        return instance.contains(descriptor);
    }

    @Override
    public boolean supportsNullCreation() {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        Instance instance = this.current();
        instance.remove(descriptor);
    }

    @Override
    public void shutdown() {
        this.currentScopeInstance = null;
    }

    public Instance referenceCurrent() throws IllegalStateException {
        return this.current().getReference();
    }

    private Instance current() {
        Instance scopeInstance = this.currentScopeInstance.get();
        Preconditions.checkState(scopeInstance != null, "Not inside a request scope.");
        return scopeInstance;
    }

    public Instance suspendCurrent() {
        Instance instance;
        Instance scopeInstance = this.currentScopeInstance.get();
        if (scopeInstance == null) {
            return null;
        }
        try {
            instance = scopeInstance.getReference();
        }
        catch (Throwable throwable) {
            logger.debugLog("Returned a new reference of the request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Returned a new reference of the request scope instance {0}", scopeInstance);
        return instance;
    }

    public Instance createInstance() {
        return new Instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Instance scopeInstance, Runnable task) {
        Instance oldInstance = this.currentScopeInstance.get();
        try {
            this.currentScopeInstance.set(scopeInstance.getReference());
            Errors.process(task);
        }
        finally {
            scopeInstance.release();
            this.currentScopeInstance.set(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Runnable task) {
        Instance oldInstance = this.currentScopeInstance.get();
        Instance instance = this.createInstance();
        try {
            this.currentScopeInstance.set(instance);
            Errors.process(task);
        }
        finally {
            instance.release();
            this.currentScopeInstance.set(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Instance scopeInstance, Callable<T> task) throws Exception {
        Instance oldInstance = this.currentScopeInstance.get();
        try {
            this.currentScopeInstance.set(scopeInstance.getReference());
            T t = Errors.process(task);
            return t;
        }
        finally {
            scopeInstance.release();
            this.currentScopeInstance.set(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Callable<T> task) throws Exception {
        Instance oldInstance = this.currentScopeInstance.get();
        Instance instance = this.createInstance();
        try {
            this.currentScopeInstance.set(instance);
            T t = Errors.process(task);
            return t;
        }
        finally {
            instance.release();
            this.currentScopeInstance.set(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Instance scopeInstance, Producer<T> task) {
        Instance oldInstance = this.currentScopeInstance.get();
        try {
            this.currentScopeInstance.set(scopeInstance.getReference());
            T t = Errors.process(task);
            return t;
        }
        finally {
            scopeInstance.release();
            this.currentScopeInstance.set(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Producer<T> task) {
        Instance oldInstance = this.currentScopeInstance.get();
        Instance instance = this.createInstance();
        try {
            this.currentScopeInstance.set(instance);
            T t = Errors.process(task);
            return t;
        }
        finally {
            instance.release();
            this.currentScopeInstance.set(oldInstance);
        }
    }

    public static final class Instance {
        private final LazyUid id = new LazyUid();
        private final Map<ActiveDescriptor<?>, Object> store = new HashMap();
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        private Instance() {
        }

        private Instance getReference() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        <T> T get(ActiveDescriptor<T> descriptor) {
            return (T)this.store.get(descriptor);
        }

        <T> T put(ActiveDescriptor<T> descriptor, T value) {
            Preconditions.checkState(!this.store.containsKey(descriptor), "An instance for the descriptor %s was already seeded in this scope. Old instance: %s New instance: %s", descriptor, this.store.get(descriptor), value);
            return (T)this.store.put(descriptor, value);
        }

        <T> void remove(ActiveDescriptor<T> descriptor) {
            Object removed = this.store.remove(descriptor);
            if (removed != null) {
                descriptor.dispose(removed);
            }
        }

        private <T> boolean contains(ActiveDescriptor<T> provider) {
            return this.store.containsKey(provider);
        }

        public void release() {
            if (this.referenceCounter.decrementAndGet() < 1) {
                try {
                    for (ActiveDescriptor<?> descriptor : Sets.newHashSet(this.store.keySet())) {
                        this.remove(descriptor);
                    }
                }
                catch (Throwable throwable) {
                    logger.debugLog("Released scope instance {0}", this);
                    throw throwable;
                }
                logger.debugLog("Released scope instance {0}", this);
            }
        }

        public String toString() {
            return Objects.toStringHelper(this).add("id", this.id.value()).add("referenceCounter", this.referenceCounter.get()).add("store size", this.store.size()).toString();
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(new RequestScope()).to(RequestScope.class);
        }
    }
}

