/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.AquamapsNative;
import org.gcube.dataanalysis.executor.nodes.algorithms.AquamapsSuitableFunctions;
import org.gcube.dataanalysis.executor.nodes.algorithms.AquamapsSuitableNode;

public class AquamapsNativeNode
extends AquamapsSuitableNode {
    @Override
    public String getName() {
        return "AQUAMAPS_NATIVE";
    }

    @Override
    public String getDescription() {
        return "Algorithm for Native Range by Aquamaps on a single node";
    }

    @Override
    public void singleStepPostprocess(Object species) {
        System.out.println("Aquamaps Algorithm Single Step PostProcess-> Analyzing Species distribution");
        ConcurrentLinkedQueue<String> rows = new ConcurrentLinkedQueue<String>();
        String speciesID = AquamapsSuitableFunctions.getMainInfoID(species);
        Map<String, Float> csquaresMap = this.operations.completeDistribution.get(speciesID);
        if (csquaresMap != null) {
            System.out.println("Aquamaps Algorithm Single Step PostProcess-> Getting csquare probabilites");
            for (String singleCsquare : csquaresMap.keySet()) {
                String additionalInformation = this.operations.getAdditionalInformation(species, this.operations.processedAreas.get(singleCsquare));
                if (additionalInformation == null) {
                    additionalInformation = "";
                } else if (additionalInformation.length() > 0) {
                    additionalInformation = "," + additionalInformation.trim();
                }
                float prob = 0.0f;
                try {
                    prob = csquaresMap.get(singleCsquare).floatValue();
                }
                catch (Exception e) {
                    System.out.println("Aquamaps Algorithm Single Step PostProcess ->Error in getting probability value at " + speciesID + " , " + singleCsquare);
                }
                if (!(prob > 0.0f)) continue;
                rows.offer("'" + speciesID + "','" + singleCsquare + "','" + MathFunctions.roundDecimal((double)prob, (int)3) + "'" + additionalInformation);
            }
            System.out.println("Aquamaps Algorithm Single Step PostProcess-> Filtering probabilities. Size:" + rows.size());
            Queue newrows = new AquamapsNative().filterProbabilitySet(rows);
            System.out.println("Aquamaps Algorithm Single Step PostProcess-> Filtered probabilities. Size:" + newrows.size());
            System.out.println("Aquamaps Algorithm Single Step PostProcess-> Writing rows on DB");
            ArrayList<String> toWrite = new ArrayList<String>();
            for (String row : newrows) {
                toWrite.add(row);
            }
            AquamapsSuitableFunctions.writeOnDB(toWrite, this.currentconfig.getParam("DistributionTable"), this.dbHibConnection);
            System.out.println("Aquamaps Algorithm Single Step PostProcess-> Rows written on DB");
        } else {
            System.out.println("Aquamaps Algorithm Single Step PostProcess-> Probability distribution is void");
        }
    }
}

