/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import java.util.HashMap;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;

public class TestsMetaInfo {
    public static void main(String[] args) throws Exception {
        System.out.println("***TEST 1 - Get Generation Algorithm Parameters***");
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        StatisticalType type = GeneratorsFactory.getAlgorithmOutput((String)"./cfg/", (String)"AQUAMAPS_SUITABLE");
        System.out.println("output for AQUAMAPS_SUITABLE algorithm: " + type);
        type = ModelersFactory.getModelOutput((String)"./cfg/", (String)"HSPEN");
        System.out.println("output for HSPEN algorithm: " + type);
        type = EvaluatorsFactory.getEvaluatorOutput((String)"./cfg/", (String)"HRS");
        System.out.println("output for HRS  algorithm: " + type);
        type = ClusterersFactory.getClustererOutput((String)"./cfg/", (String)"DBSCAN");
        System.out.println("output for DBSCAN algorithm: " + type);
        type = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)config, (String)"BIOCLIMATE_HSPEC");
        System.out.println("output for BIOCLIMATE_HSPEC algorithm: " + type);
        type = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)config, (String)"BIONYM_LOCAL");
        System.out.println("output for BIONYM_LOCAL algorithm: " + type);
        List map = GeneratorsFactory.getAlgorithmParameters((String)"./cfg/", (String)"AQUAMAPS_SUITABLE");
        System.out.println("input for AQUAMAPS_SUITABLE algorithm: " + map);
        System.out.println("\n***TEST 2 - Get Generator***");
        Generator g = GeneratorsFactory.getGenerator((AlgorithmConfiguration)TestsMetaInfo.testConfig());
        System.out.println("Found generator " + g);
        System.out.println("\n***TEST 3 - Get All Generation Algorithms ***");
        System.out.println("Algs: " + GeneratorsFactory.getProbabilityDistributionAlgorithms((String)"./cfg/"));
        System.out.println("\n***TEST 4 - Get All Generators ***");
        System.out.println("Gens: " + GeneratorsFactory.getAllGenerators((String)"./cfg/"));
        System.out.println("\n***TEST 5 - Get All Models to be trained ***");
        System.out.println("Models: " + ModelersFactory.getModels((String)"./cfg/"));
        System.out.println("\n***TEST 6 - Get All Modelers ***");
        System.out.println("Models: " + ModelersFactory.getModelers((String)"./cfg/"));
        System.out.println("\n***TEST 7- Get Model parameters ***");
        map = ModelersFactory.getModelParameters((String)"./cfg/", (String)"HSPEN");
        System.out.println("input for HSPEN algorithm: " + map);
        System.out.println("\n***TEST 8- Get Database Default Parameters***");
        map = ProcessorsFactory.getDefaultDatabaseConfiguration((String)"./cfg/");
        System.out.println("Database Default Values: " + map);
        System.out.println("\n***TEST 9- Get All Evaluators ***");
        System.out.println("Database Default Values: " + EvaluatorsFactory.getAllEvaluators((String)"./cfg/"));
        System.out.println("\n***TEST 10- Get Evaluator Parameters ***");
        map = EvaluatorsFactory.getEvaluatorParameters((String)"./cfg/", (String)"QUALITY_ANALYSIS");
        System.out.println("Database Default Values: " + map);
        System.out.println("\n***TEST 11- Get Evaluators with a config***");
        List eval = EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)TestsMetaInfo.testConfigEvaluator());
        System.out.println("Database Default Values: " + eval);
        System.out.println("\n***TEST 12- Get All Supported features***");
        HashMap features = ProcessorsFactory.getAllFeatures((AlgorithmConfiguration)config);
        System.out.println("Database Default Values: " + features);
        System.out.println("\n***TEST 13- Get All Clusterers***");
        System.out.println("All Clusterers: " + ClusterersFactory.getAllClusterers((String)"./cfg/"));
        System.out.println("\n***TEST 14- Get Clusterer Parameters ***");
        map = ClusterersFactory.getClustererParameters((String)"./cfg/", (String)"DBSCAN");
        System.out.println("Clusterers Params: " + map);
        System.out.println("\n***TEST 15- Get Clusterers with a config***");
        System.out.println("\n***TEST 16- Get All Transducerers***");
        System.out.println("All Transducers: " + TransducerersFactory.getAllTransducerers((AlgorithmConfiguration)config));
        System.out.println("\n***TEST 17- Get Transducerers Parameters ***");
        map = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)config, (String)"BIOCLIMATE_HSPEC");
        System.out.println("Transducerers Params: " + map);
        System.out.println("\n***TEST 18- Get Transducerers with a config***");
        System.out.println("\n***TEST 19- Get Agent Description***");
        String desc = ClusterersFactory.getDescription((String)"./cfg/", (String)"DBSCAN");
        System.out.println("DESCRIPTION: " + desc);
        System.out.println("\n***TEST 20- Get USER perspective***");
        HashMap m = ProcessorsFactory.getAllFeaturesUser((AlgorithmConfiguration)config);
        System.out.println("USER PERSPECTIVE: " + m);
        int cores = Runtime.getRuntime().availableProcessors();
        System.out.println("Number of cores: " + cores);
    }

    private static AlgorithmConfiguration testConfigTrans() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(Integer.valueOf(1));
        config.setAgent("TESTTRANS");
        return config;
    }

    private static AlgorithmConfiguration testConfigClusterer() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(Integer.valueOf(1));
        config.setAgent("DBSCAN");
        return config;
    }

    private static AlgorithmConfiguration testConfigEvaluator() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(Integer.valueOf(2));
        config.setAgent("QUALITY_ANALYSIS");
        return config;
    }

    private static AlgorithmConfiguration testConfig() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(Integer.valueOf(2));
        config.setModel("TEST");
        config.setAgent("SIMPLE_LOCAL");
        return config;
    }
}

