/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.interfaces;

import java.net.URLEncoder;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.executor.util.InfraRetrieval;

public abstract class StandardLocalInfraAlgorithm
extends StandardLocalExternalAlgorithm {
    public void sendNotification(String subject, String body) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Emailing System->Starting request of email in scope " + this.config.getGcubeScope()));
        String serviceAddress = InfraRetrieval.findEmailingSystemAddress(this.config.getGcubeScope());
        if (!serviceAddress.endsWith("/")) {
            serviceAddress = serviceAddress + "/";
        }
        String requestForMessage = serviceAddress + "messages/writeMessageToUsers" + "?gcube-token=" + this.config.getGcubeToken();
        requestForMessage = requestForMessage.replace("http://", "https://").replace(":80", "");
        AnalysisLogger.getLogger().debug((Object)("Emailing System->Request url is going to be " + requestForMessage));
        subject = URLEncoder.encode(subject, "UTF-8");
        body = URLEncoder.encode(body, "UTF-8");
        String requestParameters = "sender=dataminer&recipients=" + this.config.getGcubeUserName() + "&subject=" + subject + "&body=" + body;
        String response = HttpRequest.sendPostRequest((String)requestForMessage, (String)requestParameters);
        AnalysisLogger.getLogger().debug((Object)"Emailing System->Emailing response OK ");
        if (response == null) {
            Exception e = new Exception("Error in email sending response");
            throw e;
        }
    }
}

