/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.rscripts.generic;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.ZipTools;
import org.gcube.dataanalysis.executor.rscripts.generic.FileUtils;
import org.gcube.dataanalysis.executor.util.LocalRScriptsManager;
import org.gcube.dataanalysis.executor.util.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericRScript
extends StandardLocalInfraAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRScript.class);
    protected HashMap<String, String> outputValues = new HashMap();
    protected LinkedHashMap<String, StatisticalType> output = new LinkedHashMap();
    LocalRScriptsManager scriptmanager;
    protected String mainScriptName = "";
    protected String packageURL = "";
    protected List<String> environmentalvariables = new ArrayList<String>();
    protected List<String> inputvariables = new ArrayList<String>();
    protected List<String> outputvariables = new ArrayList<String>();

    public void shutdown() {
        if (this.scriptmanager != null) {
            this.scriptmanager.stop();
        }
        System.gc();
    }

    public void init() throws Exception {
        LOGGER.debug("Initializing " + ((Object)((Object)this)).getClass().getCanonicalName());
        this.initVariables();
    }

    /*
     * WARNING - void declaration
     */
    protected void process() throws Exception {
        boolean deletefiles = true;
        String Rlog = null;
        this.status = 0.0f;
        try {
            void var11_25;
            this.scriptmanager = new LocalRScriptsManager();
            LOGGER.debug("Starting script");
            File localPackage = new File(this.config.getConfigPath(), "package" + UUID.randomUUID() + ".zip");
            LOGGER.debug("Downloading package " + this.packageURL + "as: " + localPackage.getAbsolutePath());
            StorageUtils.downloadInputFile(this.packageURL, localPackage.getAbsolutePath(), true);
            LOGGER.debug("Generating sandbox folder");
            File folder = new File(this.config.getConfigPath(), "rscr_" + UUID.randomUUID());
            boolean mkdir = folder.mkdir();
            LOGGER.debug("Sandbox " + folder.getAbsolutePath() + " generated: " + mkdir);
            LOGGER.debug("Unzipping package into " + folder.getAbsolutePath());
            ZipTools.unZip((String)localPackage.getAbsolutePath(), (String)folder.getAbsolutePath());
            localPackage.delete();
            LOGGER.debug("Analysing inputs");
            LinkedHashMap<String, String> inputParameters = new LinkedHashMap<String, String>();
            int i = 0;
            List inputs = this.getInputParameters();
            for (String string : this.inputvariables) {
                void var11_17;
                String string2 = this.config.getParam(string);
                if (string2 == null) {
                    String string3 = "";
                }
                String defaultValue = ((StatisticalType)inputs.get(i)).getDefaultValue();
                defaultValue = defaultValue.replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("|", "\\|").replace(".", "\\.").replace("?", "\\?").replace("*", "\\*").replace("+", "\\+").replace("{", "\\{").replace("}", "\\}");
                String punct = "[ \t\";]*";
                String regexp = punct + string + punct + "(<-|=)" + punct + defaultValue + punct + ".*";
                boolean string4 = true;
                try {
                    Double.parseDouble((String)var11_17);
                    string4 = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object line = string + "=" + (String)var11_17;
                if (!(!string4 || var11_17.equals("T") || var11_17.equalsIgnoreCase("true") || var11_17.equalsIgnoreCase("false") || var11_17.equalsIgnoreCase("F"))) {
                    line = string + "=\"" + (String)var11_17 + "\"";
                }
                inputParameters.put(regexp, (String)line);
                ++i;
            }
            LOGGER.debug("Inputs: " + inputParameters.toString());
            LOGGER.debug("Analysing environmental variables");
            LinkedHashMap<String, String> environmentalParameters = new LinkedHashMap<String, String>();
            for (String string : this.environmentalvariables) {
                String value = this.config.getParam(string);
                environmentalParameters.put(string, value);
            }
            LOGGER.debug("Environmental: " + environmentalParameters.toString());
            LOGGER.debug("Analysing output variables");
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String output : this.outputvariables) {
                linkedHashMap.put(output, "");
            }
            LOGGER.debug("Output: " + linkedHashMap.toString());
            LOGGER.debug("Main script: " + this.mainScriptName);
            LOGGER.debug("Processing main script name");
            String string = this.mainScriptName;
            String scriptSubfolder = "";
            int lioSlash = string.lastIndexOf("/");
            if (lioSlash > -1) {
                scriptSubfolder = string.substring(0, lioSlash);
                String string5 = string.substring(lioSlash + 1);
            }
            scriptSubfolder = new File(folder.getAbsoluteFile(), scriptSubfolder).getAbsolutePath();
            LOGGER.debug("Main script name: " + (String)var11_25);
            LOGGER.debug("Main script folder: " + scriptSubfolder);
            boolean scriptMustReturnAFile = false;
            boolean uploadScriptOnTheInfrastructureWorkspace = false;
            this.status = 10.0f;
            LOGGER.debug("Executing the script...");
            environmentalParameters.put("gcube_token", "\"" + this.config.getGcubeToken() + "\"");
            Rlog = this.scriptmanager.executeRScript(this.config, (String)var11_25, null, environmentalParameters, linkedHashMap, null, null, inputParameters, scriptMustReturnAFile, uploadScriptOnTheInfrastructureWorkspace, deletefiles, scriptSubfolder);
            LOGGER.debug("..execution finished!");
            LOGGER.debug("Getting output");
            for (String output : this.outputvariables) {
                File outPath = new File(scriptSubfolder, output);
                LOGGER.debug("Output " + output + " - loading respective file from " + outPath.getAbsolutePath());
                LOGGER.debug("File exists? " + outPath.exists());
                String fileContent = FileTools.loadString((String)outPath.getAbsolutePath(), (String)"UTF-8");
                fileContent = this.analyseContent(fileContent, scriptSubfolder);
                LOGGER.debug("Retrieved output content: " + output + ": " + fileContent);
                this.outputValues.put(output, fileContent);
            }
            try {
                if (deletefiles) {
                    LOGGER.debug("Deleting sandbox folder");
                    org.apache.commons.io.FileUtils.cleanDirectory((File)folder);
                    org.apache.commons.io.FileUtils.deleteDirectory((File)folder);
                    LOGGER.debug("Folder " + folder.getAbsolutePath() + " deleted");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not delete sandbox folder " + folder.getAbsolutePath(), (Throwable)e);
            }
            if (Rlog != null) {
                File logFile = this.saveLogFile(Rlog);
                this.output.put("Log", (StatisticalType)new PrimitiveType(File.class.getName(), (Object)logFile, PrimitiveTypes.FILE, "LogFile", "Log of the computation"));
            }
        }
        catch (Exception e) {
            if (Rlog != null) {
                String httpurl = this.generateRemoteLogFile(Rlog);
                String message = "Logs of the script can be found at " + httpurl;
                e = new Exception(message);
            }
            throw e;
        }
        finally {
            LOGGER.debug("Computation finished.");
            this.status = 100.0f;
        }
    }

    protected File saveLogFile(String Rlog) throws Exception {
        String uuid = UUID.randomUUID().toString();
        LOGGER.debug("Writing the logs of the execution");
        File logfile = new File(this.config.getPersistencePath(), "RLOG" + uuid + ".txt");
        FileWriter fw = new FileWriter(logfile);
        fw.write(Rlog);
        fw.close();
        LOGGER.debug("Written in " + logfile);
        return logfile;
    }

    protected String generateRemoteLogFile(String Rlog) throws Exception {
        String uuid = "" + UUID.randomUUID();
        LOGGER.debug("Writing the logs of the execution");
        File logfile = new File(this.config.getPersistencePath(), "RLOG" + uuid + ".txt");
        FileWriter fw = new FileWriter(logfile);
        fw.write(Rlog);
        fw.close();
        LOGGER.debug("Written in " + logfile);
        String httpurl = StorageUtils.uploadFilesOnStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), logfile.getParent(), "/ScriptLogs/" + uuid + "/", logfile.getName(), true);
        LOGGER.debug("Uploaded on storage: " + httpurl);
        LOGGER.debug("Deleting log file and returning " + httpurl);
        logfile.delete();
        return httpurl;
    }

    protected String analyseContent(String filecontent, String scriptfolder) throws Exception {
        LOGGER.debug("Analysing file content");
        String[] rows = filecontent.split(System.lineSeparator());
        ArrayList<String> files = new ArrayList<String>();
        for (String row : rows) {
            LOGGER.debug("Analysing -> " + row);
            if (row == null) continue;
            row = row.replace("\"", "");
            File rowFile = new File(row.trim());
            LOGGER.debug("Checking row file-> " + rowFile.getAbsolutePath());
            if (!rowFile.exists()) {
                rowFile = new File(scriptfolder, row.trim());
                LOGGER.debug("File does not exist - checking complete row file-> " + rowFile.getAbsolutePath());
            }
            if (rowFile.exists()) {
                String preparedFile = new File(this.config.getConfigPath(), rowFile.getName()).getAbsolutePath();
                LOGGER.debug("Copying " + rowFile.getAbsolutePath() + " to " + preparedFile);
                try {
                    FileUtils.moveFileToDirectory(rowFile, new File(this.config.getConfigPath()), false);
                    files.add(preparedFile);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("error in moving file " + rowFile.getAbsolutePath() + " to " + preparedFile, (Throwable)e);
                    throw e;
                }
            }
            LOGGER.debug("Checking row file does not exist - treating as a String");
        }
        if (files.size() > 0) {
            LOGGER.debug("A File was recognized as output");
            return (String)files.get(0);
        }
        LOGGER.debug("A String was recognized as output");
        return filecontent;
    }

    protected void initVariables() {
    }

    protected void setInputParameters() {
    }

    public StatisticalType getOutput() {
        return null;
    }
}

