/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.crypto;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class MagicRsaPublicKey {
    private final PublicKey publicKey;

    public MagicRsaPublicKey(String magicKey) {
        this.publicKey = MagicRsaPublicKey.parseKey(magicKey);
    }

    public PublicKey getKey() {
        return this.publicKey;
    }

    private static PublicKey parseKey(String magicKey) {
        KeyFactory fac;
        String[] pieces = magicKey.split(Pattern.quote("."));
        if (pieces.length != 3) {
            throw new IllegalStateException("not a valid magic key: " + magicKey);
        }
        if (!pieces[0].equals("RSA")) {
            throw new IllegalStateException("unkown key type for magic key: " + pieces[0]);
        }
        String modulusString = pieces[1];
        String exponentString = pieces[2];
        byte[] modulusBytes = Base64.decodeBase64((String)modulusString);
        byte[] exponentBytes = Base64.decodeBase64((String)exponentString);
        BigInteger modulus = new BigInteger(modulusBytes);
        BigInteger exponent = new BigInteger(exponentBytes);
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        try {
            fac = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("RSA key factory missing on platform", e);
        }
        try {
            return fac.generatePublic(spec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("bad key in descripor doc: " + magicKey, e);
        }
    }
}

