/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextWrapper;
import org.apache.abdera.writer.Writer;

public class JSONFilter
implements Filter {
    public ResponseContext filter(RequestContext request, FilterChain chain) {
        ResponseContext resp = chain.next(request);
        String format = request.getParameter("format");
        return resp.getContentType() != null && this.jsonPreferred(request, resp.getContentType().toString()) || format != null && format.equalsIgnoreCase("json") ? new JsonResponseContext(resp, request.getAbdera()) : resp;
    }

    private boolean jsonPreferred(RequestContext request, String type) {
        return ProviderHelper.isPreferred(request, "application/json", type);
    }

    private class JsonResponseContext
    extends ResponseContextWrapper {
        private final Abdera abdera;

        public JsonResponseContext(ResponseContext response, Abdera abdera) {
            super(response);
            this.setContentType("application/json");
            this.abdera = abdera;
        }

        public void writeTo(OutputStream out, Writer writer) throws IOException {
            try {
                this.toJson(out, writer);
            }
            catch (Exception se) {
                if (se instanceof RuntimeException) {
                    throw (RuntimeException)se;
                }
                throw new RuntimeException(se);
            }
        }

        public void writeTo(OutputStream out) throws IOException {
            try {
                this.toJson(out, null);
            }
            catch (Exception se) {
                if (se instanceof RuntimeException) {
                    throw (RuntimeException)se;
                }
                throw new RuntimeException(se);
            }
        }

        private void toJson(OutputStream aout, Writer writer) throws Exception {
            Document doc = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (writer == null) {
                    super.writeTo(out);
                } else {
                    super.writeTo(out, writer);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                doc = this.abdera.getParser().parse(in);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (doc == null) {
                throw new RuntimeException("There was an error serializing the entry to JSON");
            }
            doc.writeTo("json", aout);
        }
    }
}

