/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.abdera.i18n.templates.CachingContext;
import org.apache.abdera.i18n.templates.Context;
import org.apache.abdera.i18n.templates.HashMapContext;
import org.apache.abdera.i18n.templates.ObjectContext;
import org.apache.abdera.i18n.templates.Route;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.SimpleTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteManager
implements Resolver<Target>,
TargetBuilder {
    protected List<RouteTargetType> targets = new ArrayList<RouteTargetType>();
    protected Map<String, Route> routes = new HashMap<String, Route>();
    protected Map<Route, CollectionAdapter> route2CA = new HashMap<Route, CollectionAdapter>();

    public RouteManager addRoute(Route route) {
        return this.addRoute(route, null);
    }

    public RouteManager addRoute(String name, String pattern) {
        return this.addRoute(name, pattern, null);
    }

    public RouteManager addRoute(Route route, TargetType type) {
        this.routes.put(route.getName(), route);
        if (type != null) {
            this.targets.add(new RouteTargetType(route, type));
        }
        return this;
    }

    public RouteManager addRoute(String name, String pattern, TargetType type) {
        return this.addRoute(new Route(name, pattern), type);
    }

    public RouteManager addRoute(String name, String pattern, TargetType type, CollectionAdapter collectionAdapter) {
        Route route = new Route(name, pattern);
        this.route2CA.put(route, collectionAdapter);
        return this.addRoute(route, type);
    }

    @Override
    public Target resolve(Request request) {
        RouteTargetType target;
        RequestContext context = (RequestContext)request;
        String uri = context.getTargetPath();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        if ((target = this.get(uri)) == null) {
            target = this.match(uri);
        }
        if (target != null) {
            return this.getTarget(context, target, uri);
        }
        return null;
    }

    private RouteTargetType get(String uri) {
        for (RouteTargetType target : this.targets) {
            if (!target.route.getPattern().equals(uri)) continue;
            return target;
        }
        return null;
    }

    private RouteTargetType match(String uri) {
        for (RouteTargetType target : this.targets) {
            if (!target.route.match(uri)) continue;
            return target;
        }
        return null;
    }

    private Target getTarget(RequestContext context, RouteTargetType target, String uri) {
        CollectionAdapter ca = this.route2CA.get(target.route);
        if (ca != null) {
            context.setAttribute("collectionProvider", ca);
        }
        return this.getTarget(context, target.route, uri, target.targetType);
    }

    private Target getTarget(RequestContext context, Route route, String uri, TargetType type) {
        return new RouteTarget(type, context, route, uri);
    }

    @Override
    public String urlFor(RequestContext context, Object key, Object param) {
        Route route = this.routes.get(key);
        return route != null ? context.getContextPath() + route.expand(this.getContext(param)) : null;
    }

    private Context getContext(Object param) {
        Context context = new EmptyContext();
        if (param != null) {
            context = param instanceof Map ? new HashMapContext(this.cleanMapCtx(param), true) : (param instanceof Context ? (Context)param : new ObjectContext(param, true));
        }
        return context;
    }

    private Map<String, Object> cleanMapCtx(Object param) {
        HashMap map = new HashMap();
        for (Map.Entry entry : ((Map)param).entrySet()) {
            map.put(((String)entry.getKey()).replaceFirst("^:", ""), entry.getValue());
        }
        ((Map)param).clear();
        ((Map)param).putAll(map);
        return (Map)param;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RouteTarget
    extends SimpleTarget {
        private final Map<String, String> params;
        private final Route route;

        public RouteTarget(TargetType type, RequestContext context, Route route, String uri) {
            super(type, context);
            this.route = route;
            this.params = route.parse(uri);
        }

        public Route getRoute() {
            return this.route;
        }

        @Override
        public <T> T getMatcher() {
            return (T)this.getRoute();
        }

        @Override
        public String getParameter(String name) {
            return this.params.containsKey(name) ? this.params.get(name) : super.getParameter(name);
        }

        @Override
        public String[] getParameterNames() {
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getParameterNames()));
            for (String name : this.params.keySet()) {
                if (names.contains(name)) continue;
                names.add(name);
            }
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyContext
    extends CachingContext {
        private static final long serialVersionUID = 4681906592987534451L;

        private EmptyContext() {
        }

        @Override
        protected <T> T resolveActual(String var) {
            return null;
        }

        @Override
        public Iterator<String> iterator() {
            List<String> list = Arrays.asList(new String[0]);
            return list.iterator();
        }
    }

    protected class RouteTargetType {
        protected Route route;
        protected TargetType targetType;

        RouteTargetType(Route route, TargetType targetType) {
            this.route = route;
            this.targetType = targetType;
        }

        public Route getRoute() {
            return this.route;
        }

        public TargetType getTargetType() {
            return this.targetType;
        }
    }
}

