/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.spring;

import java.util.List;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.spring.AbstractSingleBeanDefinitionParser;
import org.apache.abdera.spring.ProviderFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultProviderDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected void mapAttribute(BeanDefinitionBuilder bean, Element element, String name, String val) {
        if (name.equals("base")) {
            bean.addPropertyValue(name, (Object)val);
        } else if (name.equals("class")) {
            bean.addPropertyValue("providerClass", (Object)val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element element, String name) {
        if (name.equals("workspaceManager")) {
            this.setFirstChildAsProperty(element, ctx, bean, "workspaceManager");
        } else if (name.equals("targetResolver")) {
            this.setFirstChildAsProperty(element, ctx, bean, "targetResolver");
        } else if (name.equals("subjectResolver")) {
            this.setFirstChildAsProperty(element, ctx, bean, name);
        } else if (name.equals("filter")) {
            MutablePropertyValues values = bean.getBeanDefinition().getPropertyValues();
            PropertyValue pv = values.getPropertyValue("filters");
            List filters = pv != null ? (List)pv.getValue() : new ManagedList();
            NodeList nodes = element.getChildNodes();
            Object child = null;
            if (element.hasAttribute("ref")) {
                if (!StringUtils.hasText((String)element.getAttribute("ref"))) {
                    ctx.getReaderContext().error(name + " contains empty 'ref' attribute", (Object)element);
                }
                child = new RuntimeBeanReference(element.getAttribute("ref"));
                child.setSource(ctx.extractSource((Object)element));
            } else if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node n = nodes.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element childElement = (Element)n;
                    child = ctx.getDelegate().parsePropertySubElement(childElement, (BeanDefinition)bean.getRawBeanDefinition());
                }
            }
            if (child != null) {
                filters.add(child);
            }
            bean.addPropertyValue("filters", (Object)filters);
        } else if (name.equals("workspace")) {
            String id = this.getAndRegister(ctx, bean, element);
            bean.addPropertyReference("workspaces", id);
        } else if (name.equals("property")) {
            ctx.getDelegate().parsePropertyElement(element, (BeanDefinition)bean.getRawBeanDefinition());
        }
    }

    protected String getBeanClassName(Element arg0) {
        String cls = super.getBeanClassName(arg0);
        if (cls == null) {
            cls = ProviderFactoryBean.class.getName();
        }
        return cls;
    }

    protected String resolveId(Element element, AbstractBeanDefinition arg1, ParserContext arg2) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (id == null || "".equals(id)) {
            id = Provider.class.getName();
        }
        return id;
    }
}

