/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.MessageExtensionFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;
import org.openid4java.message.pape.PapeMessage;
import org.openid4java.message.sreg.SReg11ExtensionFactory;
import org.openid4java.message.sreg.SRegMessage;

public class Message {
    private static Log _log = LogFactory.getLog(Message.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String MODE_IDRES = "id_res";
    public static final String MODE_CANCEL = "cancel";
    public static final String MODE_SETUP_NEEDED = "setup_needed";
    public static final String OPENID2_NS = "http://specs.openid.net/auth/2.0";
    private ParameterList _params = new ParameterList();
    private int _extCounter = 0;
    private Map _extAliases = new HashMap();
    private Map _extesion = new HashMap();
    protected String _destinationUrl;
    private static Map _extensionFactories = new HashMap();

    protected Message() {
    }

    protected Message(ParameterList params) {
        this();
        this._params = params;
        Iterator iter = this._params.getParameters().iterator();
        boolean hasOpenidDotSreg = false;
        while (iter.hasNext()) {
            String key = ((Parameter)iter.next()).getKey();
            if (key.startsWith("openid.ns.") && key.length() > 10) {
                this._extAliases.put(this._params.getParameter(key).getValue(), key.substring(10));
            }
            if (!key.startsWith("openid.sreg.")) continue;
            hasOpenidDotSreg = true;
        }
        if (hasOpenidDotSreg && !this._extAliases.values().contains("sreg")) {
            this._extAliases.put("http://openid.net/sreg/1.0", "sreg");
        }
        this._extCounter = this._extAliases.size();
    }

    public static Message createMessage() throws MessageException {
        Message message = new Message();
        message.validate();
        if (DEBUG) {
            _log.debug((Object)("Created message:\n" + message.keyValueFormEncoding()));
        }
        return message;
    }

    public static Message createMessage(ParameterList params) throws MessageException {
        Message message = new Message(params);
        message.validate();
        if (DEBUG) {
            _log.debug((Object)("Created message from parameter list:\n" + message.keyValueFormEncoding()));
        }
        return message;
    }

    protected Parameter getParameter(String name) {
        return this._params.getParameter(name);
    }

    public String getParameterValue(String name) {
        return this._params.getParameterValue(name);
    }

    public boolean hasParameter(String name) {
        return this._params.hasParameter(name);
    }

    protected void set(String name, String value) {
        this._params.set(new Parameter(name, value));
    }

    protected List getParameters() {
        return this._params.getParameters();
    }

    public Map getParameterMap() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Parameter p : this._params.getParameters()) {
            params.put(p.getKey(), p.getValue());
        }
        return params;
    }

    public void validate() throws MessageException {
        List requiredFields = this.getRequiredFields();
        for (Parameter param : this._params.getParameters()) {
            if (param.isValid()) continue;
            throw new MessageException("Invalid parameter: " + param);
        }
        if (requiredFields == null) {
            return;
        }
        for (String required : requiredFields) {
            if (this.hasParameter(required)) continue;
            throw new MessageException("Required parameter missing: " + required);
        }
    }

    public List getRequiredFields() {
        return null;
    }

    public String keyValueFormEncoding() {
        return this._params.toString();
    }

    public String wwwFormEncoding() {
        StringBuffer allParams = new StringBuffer("");
        List parameters = this._params.getParameters();
        for (Parameter parameter : parameters) {
            if (!parameter.getKey().startsWith("openid.")) {
                allParams.append("openid.");
            }
            try {
                allParams.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                allParams.append('=');
                allParams.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
                allParams.append('&');
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (allParams.length() > 0) {
            allParams.deleteCharAt(allParams.length() - 1);
        }
        return allParams.toString();
    }

    public String getDestinationUrl(boolean httpGet) {
        if (this._destinationUrl == null) {
            throw new IllegalStateException("Destination URL not set; is this a received message?");
        }
        if (httpGet) {
            boolean hasQuery = this._destinationUrl.indexOf("?") > 0;
            String initialChar = hasQuery ? "&" : "?";
            return this._destinationUrl + initialChar + this.wwwFormEncoding();
        }
        return this._destinationUrl;
    }

    public static void addExtensionFactory(Class clazz) throws MessageException {
        try {
            MessageExtensionFactory extensionFactory = (MessageExtensionFactory)clazz.newInstance();
            if (DEBUG) {
                _log.debug((Object)("Adding extension factory for " + extensionFactory.getTypeUri()));
            }
            _extensionFactories.put(extensionFactory.getTypeUri(), clazz);
        }
        catch (Exception e) {
            throw new MessageException("Cannot instantiante message extension factory class: " + clazz.getName());
        }
    }

    public static boolean hasExtensionFactory(String typeUri) {
        return _extensionFactories.containsKey(typeUri);
    }

    public static MessageExtensionFactory getExtensionFactory(String typeUri) {
        MessageExtensionFactory extensionFactory;
        if (!Message.hasExtensionFactory(typeUri)) {
            return null;
        }
        try {
            Class extensionClass = (Class)_extensionFactories.get(typeUri);
            extensionFactory = (MessageExtensionFactory)extensionClass.newInstance();
        }
        catch (Exception e) {
            _log.error((Object)("Error getting extension factory for " + typeUri));
            return null;
        }
        return extensionFactory;
    }

    public boolean hasExtension(String typeUri) {
        return this._extAliases.containsKey(typeUri);
    }

    public Set getExtensions() {
        return this._extAliases.keySet();
    }

    public String getExtensionAlias(String extensionTypeUri) {
        return this._extAliases.get(extensionTypeUri) != null ? (String)this._extAliases.get(extensionTypeUri) : null;
    }

    public void addExtension(MessageExtension extension) throws MessageException {
        this.addExtension(extension, null);
    }

    public String addExtension(MessageExtension extension, String preferredAlias) throws MessageException {
        String alias;
        String typeUri = extension.getTypeUri();
        if (this.hasExtension(typeUri)) {
            throw new MessageException("Extension already present: " + typeUri);
        }
        String string = alias = preferredAlias != null && !this._extAliases.containsValue(preferredAlias) ? preferredAlias : "ext" + Integer.toString(++this._extCounter);
        if (!this.hasParameter("openid.ns") && preferredAlias != null && !alias.equals(preferredAlias)) {
            throw new MessageException("Cannot add (pseudo) extension to v1 message for alias: " + preferredAlias);
        }
        if ("http://openid.net/sreg/1.0".equals(typeUri)) {
            alias = "sreg";
        }
        this._extAliases.put(typeUri, alias);
        if (DEBUG) {
            _log.debug((Object)("Adding extension; type URI: " + typeUri + " alias: " + alias));
        }
        this.set("openid.ns." + alias, typeUri);
        for (Parameter param : extension.getParameters().getParameters()) {
            String paramName = param.getKey().length() > 0 ? "openid." + alias + "." + param.getKey() : "openid." + alias;
            this.set(paramName, param.getValue());
        }
        if (this instanceof AuthSuccess) {
            if (extension.signRequired()) {
                ((AuthSuccess)this).addSignExtension(typeUri);
            }
            if (((AuthSuccess)this).getSignExtensions().contains(typeUri)) {
                ((AuthSuccess)this).buildSignedList();
            }
        }
        return alias;
    }

    private ParameterList getExtensionParams(String extensionTypeUri) {
        ParameterList extension = new ParameterList();
        if (this.hasExtension(extensionTypeUri)) {
            String extensionAlias = this.getExtensionAlias(extensionTypeUri);
            for (Parameter param : this.getParameters()) {
                String paramName = null;
                if (param.getKey().startsWith("openid." + extensionAlias + ".")) {
                    paramName = param.getKey().substring(8 + extensionAlias.length());
                }
                if (param.getKey().equals("openid." + extensionAlias)) {
                    paramName = "";
                }
                if (paramName == null) continue;
                extension.set(new Parameter(paramName, param.getValue()));
            }
        }
        return extension;
    }

    public MessageExtension getExtension(String typeUri) throws MessageException {
        if (!this._extesion.containsKey(typeUri)) {
            if (Message.hasExtensionFactory(typeUri)) {
                MessageExtensionFactory extensionFactory = Message.getExtensionFactory(typeUri);
                String mode = this.getParameterValue("openid.mode");
                MessageExtension extension = extensionFactory.getExtension(this.getExtensionParams(typeUri), mode.startsWith("checkid_"));
                if (this instanceof AuthSuccess && extension.signRequired()) {
                    List<String> signedParams = Arrays.asList(((AuthSuccess)this).getSignList().split(","));
                    String alias = this.getExtensionAlias(typeUri);
                    if (this.hasParameter("openid.ns") && !signedParams.contains("ns." + alias)) {
                        throw new MessageException("Namespace declaration for extension " + typeUri + " MUST be signed");
                    }
                    for (Parameter param : extension.getParameters().getParameters()) {
                        if (signedParams.contains(alias + "." + param.getKey())) continue;
                        throw new MessageException("Extension " + typeUri + " MUST be signed; " + "field " + param.getKey() + " is NOT signed.");
                    }
                }
                this._extesion.put(typeUri, extension);
            } else {
                throw new MessageException("Cannot instantiate extension: " + typeUri);
            }
        }
        if (DEBUG) {
            _log.debug((Object)("Extracting " + typeUri + " extension from message..."));
        }
        return (MessageExtension)this._extesion.get(typeUri);
    }

    static {
        _extensionFactories.put("http://openid.net/srv/ax/1.0", AxMessage.class);
        _extensionFactories.put("http://openid.net/sreg/1.0", SRegMessage.class);
        _extensionFactories.put("http://openid.net/extensions/sreg/1.1", SReg11ExtensionFactory.class);
        _extensionFactories.put("http://specs.openid.net/extensions/pape/1.0", PapeMessage.class);
    }
}

