/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.openid4java.util.ProxyProperties;

public class HttpClientFactory {
    private static ProxyProperties proxyProperties = null;
    private static boolean multiThreadedHttpClient = true;

    private HttpClientFactory() {
    }

    public static ProxyProperties getProxyProperties() {
        return proxyProperties;
    }

    public static void setProxyProperties(ProxyProperties proxyProperties) {
        HttpClientFactory.proxyProperties = proxyProperties;
    }

    public static boolean isMultiThreadedHttpClient() {
        return multiThreadedHttpClient;
    }

    public static void setMultiThreadedHttpClient(boolean multiThreadedHttpClient) {
        HttpClientFactory.multiThreadedHttpClient = multiThreadedHttpClient;
    }

    public static HttpClient getInstance(int maxRedirects, Boolean allowCircularRedirects, int connTimeout, int socketTimeout, String cookiePolicy) {
        return HttpClientFactory.getInstance(maxRedirects, allowCircularRedirects, connTimeout, socketTimeout, cookiePolicy, null, null);
    }

    public static HttpClient getInstance(int maxRedirects, Boolean allowCircularRedirects, int connTimeout, int socketTimeout, String cookiePolicy, SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        BasicHttpParams httpParams = new BasicHttpParams();
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        SSLSocketFactory sslSocketFactory = null == sslContext ? SSLSocketFactory.getSocketFactory() : new SSLSocketFactory(sslContext);
        if (null != hostnameVerifier) {
            sslSocketFactory.setHostnameVerifier(hostnameVerifier);
        }
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory));
        Object connManager = multiThreadedHttpClient ? new ThreadSafeClientConnManager(registry) : new SingleClientConnManager(registry);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connManager, (HttpParams)httpParams);
        client.getParams().setParameter("http.protocol.max-redirects", (Object)new Integer(maxRedirects));
        client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)allowCircularRedirects);
        client.getParams().setParameter("http.socket.timeout", (Object)new Integer(socketTimeout));
        client.getParams().setParameter("http.connection.timeout", (Object)new Integer(connTimeout));
        if (cookiePolicy == null) {
            client.setCookieStore(null);
        } else {
            client.getParams().setParameter("http.protocol.cookie-policy", (Object)cookiePolicy);
        }
        if (proxyProperties != null) {
            HttpHost proxy = new HttpHost(proxyProperties.getProxyHostName(), proxyProperties.getProxyPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            Credentials credentials = proxyProperties.getCredentials();
            client.getCredentialsProvider().setCredentials(authScope, credentials);
        }
        return client;
    }
}

