/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.openid4java.util.HttpRequestOptions;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static void dispose(HttpResponse response) {
        HttpEntity e;
        if (response != null && (e = response.getEntity()) != null) {
            HttpUtils.dispose(e);
        }
    }

    public static void dispose(HttpEntity entity) {
        if (entity != null) {
            try {
                entity.consumeContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setRequestOptions(HttpRequestBase request, HttpRequestOptions requestOptions) {
        request.getParams().setParameter("http.protocol.max-redirects", (Object)new Integer(requestOptions.getMaxRedirects()));
        request.getParams().setParameter("http.socket.timeout", (Object)new Integer(requestOptions.getSocketTimeout()));
        request.getParams().setParameter("http.connection.timeout", (Object)new Integer(requestOptions.getConnTimeout()));
        request.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)requestOptions.getAllowCircularRedirects());
        Map requestHeaders = requestOptions.getRequestHeaders();
        if (requestHeaders != null) {
            for (String headerName : requestHeaders.keySet()) {
                request.addHeader(headerName, (String)requestHeaders.get(headerName));
            }
        }
    }
}

