/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionOp;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class ExpressionArithmetic
extends Expression {
    ExpressionArithmetic(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    ExpressionArithmetic(int type, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        switch (this.opType) {
            case 31: {
                return;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "Expression");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        String left = ExpressionArithmetic.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String right = ExpressionArithmetic.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 91: {
                sb.append(' ').append("CAST").append('(');
                sb.append(left).append(' ').append("AS").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(')');
                break;
            }
            case 31: {
                sb.append('-').append(left);
                break;
            }
            case 32: {
                sb.append(left).append('+').append(right);
                break;
            }
            case 33: {
                sb.append(left).append('-').append(right);
                break;
            }
            case 34: {
                sb.append(left).append('*').append(right);
                break;
            }
            case 35: {
                sb.append(left).append('/').append(right);
                break;
            }
            case 36: {
                sb.append(left).append("||").append(right);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 25: 
            case 26: {
                sb.append("VALUELIST ");
                sb.append(" TYPE = ").append(this.dataType.getNameString());
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + blanks));
                    sb.append(' ');
                }
                break;
            }
            case 31: {
                sb.append("NEGATE ");
                break;
            }
            case 32: {
                sb.append("ADD ");
                break;
            }
            case 33: {
                sb.append("SUBTRACT ");
                break;
            }
            case 34: {
                sb.append("MULTIPLY ");
                break;
            }
            case 35: {
                sb.append("DIVIDE ");
                break;
            }
            case 36: {
                sb.append("CONCAT ");
                break;
            }
            case 91: {
                sb.append("CAST ");
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 31: {
                if (this.nodes[0].isUnresolvedParam() || this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[0].dataType;
                if (!this.dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 32: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isCharacterType() || this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) {
                    this.opType = 36;
                    this.resolveTypesForConcat(session, parent);
                    break;
                }
            }
            case 33: 
            case 34: 
            case 35: {
                this.resolveTypesForArithmetic(session, parent);
                break;
            }
            case 36: {
                this.resolveTypesForConcat(session, parent);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void resolveTypesForArithmetic(Session session, Expression parent) {
        if (this.nodes[0].isUnresolvedParam() && this.nodes[1].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            if (this.nodes[1].dataType == null) {
                throw Error.error(5567);
            }
            if (this.nodes[1].dataType.isDecimalType()) {
                this.nodes[0].dataType = Type.SQL_DECIMAL_DEFAULT;
            } else {
                if (this.nodes[1].dataType.isIntervalType() && parent != null) {
                    block0 : switch (parent.opType) {
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: {
                            for (int i = 0; i < parent.nodes.length; ++i) {
                                if (parent.nodes[i] == this) continue;
                                if (parent.nodes[i].dataType == null || !parent.nodes[i].dataType.isDateTimeType()) break block0;
                                this.nodes[0].dataType = parent.nodes[i].dataType;
                                break block0;
                            }
                            break;
                        }
                    }
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
            }
        } else if (this.nodes[1].isUnresolvedParam()) {
            if (this.nodes[0].dataType == null) {
                throw Error.error(5567);
            }
            this.nodes[1].dataType = this.nodes[0].dataType.isDecimalType() ? Type.SQL_DECIMAL_DEFAULT : this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.dataType != null && this.dataType.isIntervalType()) {
            if (this.nodes[0].dataType.isDateTimeType() && this.nodes[1].dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
                    throw Error.error(5562);
                }
            } else {
                Type type = this.nodes[0].dataType.getCombinedType(this.nodes[1].dataType, this.opType);
                if (type == null) {
                    // empty if block
                }
                if (type.isIntervalType()) {
                    if (type.typeCode != this.dataType.typeCode) {
                        throw Error.error(5562);
                    }
                } else {
                    if (!type.isNumberType()) throw Error.error(5562);
                    this.nodes[0] = new ExpressionOp(this.nodes[0], this.dataType);
                    this.nodes[1] = new ExpressionOp(this.nodes[1], this.dataType);
                    this.nodes[0].resolveTypes(session, this);
                    this.nodes[1].resolveTypes(session, this);
                }
            }
        } else {
            this.dataType = this.nodes[0].dataType.getCombinedType(this.nodes[1].dataType, this.opType);
            if (this.dataType.isDateTimeType() && this.nodes[0].dataType.isIntervalType()) {
                if (this.opType != 32) {
                    throw Error.error(5563);
                }
                Expression temp = this.nodes[0];
                this.nodes[0] = this.nodes[1];
                this.nodes[1] = temp;
            }
        }
        if (this.nodes[0].opType != 1 || this.nodes[1].opType != 1) return;
        this.setAsConstantValue(session);
    }

    void resolveTypesForConcat(Session session, Expression parent) {
        CharacterType newType;
        if (this.dataType != null) {
            return;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].dataType.isBinaryType() ^ this.nodes[1].dataType.isBinaryType()) {
            throw Error.error(5563);
        }
        if (this.nodes[0].dataType.isArrayType()) {
            Expression e = this.nodes[1];
            if (e.opType == 99) {
                if (parent == null) {
                    throw Error.error(5563);
                }
                this.nodes[1] = e.getLeftNode();
                e.nodes[0] = this;
                parent.replaceNode(this, e);
            }
        }
        if (this.nodes[0].dataType.isArrayType() ^ this.nodes[1].dataType.isArrayType()) {
            throw Error.error(5563);
        }
        if (this.nodes[0].dataType.isCharacterType() && !this.nodes[1].dataType.isCharacterType()) {
            if (session.database.sqlEnforceTypes) {
                throw Error.error(5562);
            }
            newType = CharacterType.getCharacterType(12, this.nodes[1].dataType.displaySize());
            this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], newType);
        }
        if (this.nodes[1].dataType.isCharacterType() && !this.nodes[0].dataType.isCharacterType()) {
            if (session.database.sqlEnforceTypes) {
                throw Error.error(5562);
            }
            newType = CharacterType.getCharacterType(12, this.nodes[0].dataType.displaySize());
            this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], newType);
        }
        this.dataType = this.nodes[0].dataType.getCombinedType(this.nodes[1].dataType, 36);
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session);
        }
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return value;
            }
            case 31: {
                return ((NumberType)this.dataType).negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
        }
        Object a = this.nodes[0].getValue(session);
        Object b = this.nodes[1].getValue(session);
        switch (this.opType) {
            case 32: {
                return this.dataType.add(a, b, this.nodes[1].dataType);
            }
            case 33: {
                return this.dataType.subtract(a, b, this.nodes[1].dataType);
            }
            case 34: {
                return this.dataType.multiply(a, b);
            }
            case 35: {
                return this.dataType.divide(session, a, b);
            }
            case 36: {
                if (!session.database.sqlConcatNulls && this.nodes[0].dataType.isCharacterType()) {
                    if (a == null && b != null) {
                        a = "";
                    } else if (a != null && b == null) {
                        b = "";
                    }
                }
                return this.dataType.concat(session, a, b);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }
}

