/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    ExpressionTable(Expression e, SubQuery sq, boolean ordinality) {
        super(30);
        this.nodes = new Expression[]{e};
        this.subQuery = sq;
        this.ordinality = ordinality;
    }

    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        if (this.isTable) {
            sb.append("TABLE").append(' ');
        } else {
            sb.append("UNNEST").append(' ');
        }
        sb.append(this.nodes[0].describe(session, blanks));
        return sb.toString();
    }

    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType.isRowType()) {
            this.isTable = true;
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.subQuery.prepareTable(session);
            this.subQuery.getTable().columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
        } else {
            this.isTable = false;
            int columnCount = this.ordinality ? 2 : 1;
            this.nodeDataTypes = new Type[columnCount];
            this.nodeDataTypes[0] = this.nodes[0].dataType.collectionBaseType();
            if (this.ordinality) {
                this.nodeDataTypes[1] = Type.SQL_INTEGER;
            }
            this.subQuery.prepareTable(session);
        }
    }

    public Result getResult(Session session) {
        switch (this.opType) {
            case 30: {
                RowSetNavigatorData navigator = this.subQuery.getNavigator(session);
                Result result = Result.newResult(navigator);
                result.metaData = this.subQuery.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 30: {
                return this.subQuery.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 30: {
                this.materialise(session);
                Object[] value = this.subQuery.getValues(session);
                if (value.length == 1) {
                    return value[0];
                }
                return value;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object getValue(Session session) {
        return this.valueData;
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore store) {
        if (this.isTable) {
            this.insertTableValues(session, store);
        } else {
            this.insertArrayValues(session, store);
        }
    }

    private void insertTableValues(Session session, PersistentStore store) {
        Result result = this.nodes[0].getResult(session);
        RowSetNavigator nav = result.navigator;
        int size = nav.getSize();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Row row = (Row)store.getNewCachedObject(session, data, false);
            try {
                store.indexRow(session, row);
            }
            catch (HsqlException e) {}
        }
    }

    private void insertArrayValues(Session session, PersistentStore store) {
        Object[] array = (Object[])this.nodes[0].getValue(session);
        for (int i = 0; i < array.length; ++i) {
            Object[] data = this.ordinality ? new Object[]{array[i], ValuePool.getInt(i + 1)} : new Object[]{array[i]};
            Row row = (Row)store.getNewCachedObject(session, data, false);
            try {
                store.indexRow(session, row);
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }
}

