/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserBase {
    private Scanner scanner;
    protected Token token;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    private final Token dummyToken = new Token();
    protected boolean isCheckOrTriggerCondition;
    protected boolean isSchemaDefinition;
    protected int parsePosition;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    ParserBase(Scanner t) {
        this.scanner = t;
        this.token = this.scanner.token;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(int parsePosition) {
        this.parsePosition = parsePosition;
    }

    void reset(String sql) {
        this.scanner.reset(sql);
        this.parsePosition = 0;
        this.isCheckOrTriggerCondition = false;
        this.isSchemaDefinition = false;
        this.isRecording = false;
        this.recordedStatement = null;
    }

    int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int position) {
        if (position == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(position);
        if (this.isRecording) {
            int i;
            for (i = this.recordedStatement.size() - 1; i >= 0; --i) {
                Token token = (Token)this.recordedStatement.get(i);
                if (token.position < position) break;
            }
            this.recordedStatement.setSize(i + 1);
        }
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.parsePosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int position) {
        return this.scanner.getPart(position, this.scanner.getTokenPosition());
    }

    String getLastPartAndCurrent(int position) {
        return this.scanner.getPart(position, this.scanner.getPosition());
    }

    String getStatement(int startPosition, short[] startTokens) {
        while (this.token.tokenType != 791 && this.token.tokenType != 848 && ArrayUtil.find(startTokens, this.token.tokenType) == -1) {
            this.read();
        }
        String sql = this.scanner.getPart(startPosition, this.scanner.getTokenPosition());
        return sql;
    }

    String getStatementForRoutine(int startPosition, short[] startTokens) {
        int tokenIndex = 0;
        int semiIndex = -1;
        int semiPosition = -1;
        while (true) {
            if (this.token.tokenType == 791) {
                semiPosition = this.scanner.getTokenPosition();
                semiIndex = tokenIndex;
            } else {
                if (this.token.tokenType == 848) {
                    if (semiIndex <= 0 || semiIndex != tokenIndex - 1) break;
                    this.rewind(semiPosition);
                    break;
                }
                if (ArrayUtil.find(startTokens, this.token.tokenType) != -1) break;
            }
            this.read();
            ++tokenIndex;
        }
        String sql = this.scanner.getPart(startPosition, this.scanner.getTokenPosition());
        return sql;
    }

    void startRecording() {
        this.recordedStatement = new HsqlArrayList();
        this.recordedStatement.add(this.token.duplicate());
        this.isRecording = true;
    }

    Token getRecordedToken() {
        if (this.isRecording) {
            return (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
        }
        return this.dummyToken;
    }

    Token[] getRecordedStatement() {
        this.isRecording = false;
        this.recordedStatement.remove(this.recordedStatement.size() - 1);
        Token[] tokens = new Token[this.recordedStatement.size()];
        this.recordedStatement.toArray(tokens);
        this.recordedStatement = null;
        return tokens;
    }

    void read() {
        this.scanner.scanNext();
        if (this.token.isMalformed) {
            int errorCode = -1;
            switch (this.token.tokenType) {
                case 856: {
                    errorCode = 5587;
                    break;
                }
                case 855: {
                    errorCode = 5588;
                    break;
                }
                case 857: {
                    errorCode = 5586;
                    break;
                }
                case 853: {
                    errorCode = 5584;
                    break;
                }
                case -1: {
                    errorCode = 5582;
                    break;
                }
                case 854: {
                    errorCode = 5585;
                    break;
                }
                case 858: {
                    errorCode = 5589;
                    break;
                }
                case 859: {
                    errorCode = 5583;
                }
            }
            throw Error.error(errorCode);
        }
        if (this.isRecording) {
            Token dup = this.token.duplicate();
            dup.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(dup);
        }
    }

    boolean isReservedKey() {
        return this.scanner.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.scanner.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.scanner.token.isReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.scanner.token.isCoreReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (this.token.tokenType != 847) {
            throw Error.error(5569);
        }
    }

    void checkIsNotQuoted() {
        if (this.token.tokenType == 847) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 845) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue(int dataTypeCode) {
        if (this.token.tokenType != 845 || this.token.dataType.typeCode != dataTypeCode) {
            throw this.unexpectedToken();
        }
    }

    void checkIsThis(int type) {
        if (this.token.tokenType != type) {
            throw this.unexpectedToken();
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && this.token.namePrefix == null;
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    void readUnquotedIdentifier(String ident) {
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(ident)) {
            throw this.unexpectedToken();
        }
        this.read();
    }

    String readQuotedString() {
        this.checkIsValue();
        if (this.token.dataType.typeCode != 1) {
            throw Error.error(5563);
        }
        String value = this.token.tokenString;
        this.read();
        return value;
    }

    void readThis(int tokenId) {
        if (this.token.tokenType != tokenId) {
            String required = Tokens.getKeyword(tokenId);
            throw this.unexpectedTokenRequire(required);
        }
        this.read();
    }

    boolean readIfThis(int tokenId) {
        if (this.token.tokenType == tokenId) {
            this.read();
            return true;
        }
        return false;
    }

    Integer readIntegerObject() {
        int value = this.readInteger();
        return ValuePool.getInt(value);
    }

    int readInteger() {
        boolean minus = false;
        if (this.token.tokenType == 784) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5563);
        }
        int val = ((Number)this.token.tokenValue).intValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    long readBigint() {
        boolean minus = false;
        if (this.token.tokenType == 784) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5563);
        }
        long val = ((Number)this.token.tokenValue).longValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    Expression readDateTimeIntervalLiteral() {
        int pos = this.getPosition();
        switch (this.token.tokenType) {
            case 72: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newDate(s);
                return new ExpressionValue(date, Type.SQL_DATE);
            }
            case 281: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimeData value = this.scanner.newTime(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(value, dataType);
            }
            case 282: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newTimestamp(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(date, dataType);
            }
            case 140: {
                boolean minus = false;
                this.read();
                if (this.token.tokenType == 784) {
                    this.read();
                    minus = true;
                } else if (this.token.tokenType == 787) {
                    this.read();
                }
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                IntervalType dataType = this.readIntervalType(false);
                Object interval = this.scanner.newInterval(s, dataType);
                dataType = (IntervalType)this.scanner.dateTimeType;
                if (minus) {
                    interval = dataType.negate(interval);
                }
                return new ExpressionValue(interval, dataType);
            }
            default: {
                throw Error.runtimeError(201, "ParserBase");
            }
        }
        this.rewind(pos);
        return null;
    }

    IntervalType readIntervalType(boolean maxPrecisionDefault) {
        int endToken;
        int precision = maxPrecisionDefault ? 9 : -1;
        int scale = -1;
        int startToken = endToken = this.token.tokenType;
        this.read();
        if (this.token.tokenType == 786) {
            this.read();
            precision = this.readInteger();
            if (precision <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 774) {
                if (startToken != 250) {
                    throw this.unexpectedToken();
                }
                this.read();
                scale = this.readInteger();
                if (scale < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(772);
        }
        if (this.token.tokenType == 285) {
            this.read();
            endToken = this.token.tokenType;
            this.read();
        }
        if (this.token.tokenType == 786) {
            if (endToken != 250 || endToken == startToken) {
                throw this.unexpectedToken();
            }
            this.read();
            scale = this.readInteger();
            if (scale < 0) {
                throw Error.error(5592);
            }
            this.readThis(772);
        }
        int startIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, startToken);
        int endIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, endToken);
        return IntervalType.getIntervalType(startIndex, endIndex, precision, scale);
    }

    static int getExpressionType(int tokenT) {
        int type = expressionTypeMap.get(tokenT, -1);
        if (type == -1) {
            throw Error.runtimeError(201, "ParserBase");
        }
        return type;
    }

    HsqlException unexpectedToken(String tokenS) {
        return Error.parseError(5581, tokenS, this.scanner.getLineNumber());
    }

    HsqlException unexpectedTokenRequire(String required) {
        if (this.token.tokenType == 848) {
            return Error.parseError(5590, 1, this.scanner.getLineNumber(), new Object[]{"", required});
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, 1, this.scanner.getLineNumber(), new Object[]{tokenS, required});
    }

    HsqlException unexpectedToken() {
        if (this.token.tokenType == 848) {
            return Error.parseError(5590, null, this.scanner.getLineNumber());
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, tokenS, this.scanner.getLineNumber());
    }

    HsqlException tooManyIdentifiers() {
        String tokenS = this.token.namePrePrePrefix != null ? this.token.namePrePrePrefix : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString));
        return Error.parseError(5551, tokenS, this.scanner.getLineNumber());
    }

    HsqlException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    HsqlException unsupportedFeature(String string) {
        return Error.error(1551, string);
    }

    public Number convertToNumber(String s, NumberType type) {
        return this.scanner.convertToNumber(s, type);
    }

    static {
        expressionTypeMap.put(396, 41);
        expressionTypeMap.put(779, 43);
        expressionTypeMap.put(782, 44);
        expressionTypeMap.put(780, 42);
        expressionTypeMap.put(783, 45);
        expressionTypeMap.put(785, 46);
        expressionTypeMap.put(52, 71);
        expressionTypeMap.put(163, 74);
        expressionTypeMap.put(168, 73);
        expressionTypeMap.put(274, 72);
        expressionTypeMap.put(16, 75);
        expressionTypeMap.put(97, 76);
        expressionTypeMap.put(6, 77);
        expressionTypeMap.put(258, 77);
        expressionTypeMap.put(269, 78);
        expressionTypeMap.put(270, 79);
        expressionTypeMap.put(309, 80);
        expressionTypeMap.put(310, 81);
        expressionTypeMap.put(9, 82);
        expressionTypeMap.put(669, 83);
        expressionTypeMap.put(604, 85);
    }
}

