/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.hsqldb.auth.AuthFunctionBean;
import org.hsqldb.auth.DenyException;
import org.hsqldb.lib.FrameworkLogger;

public class JaasAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(JaasAuthBean.class);
    private boolean initialized;
    private String applicationKey;
    private Pattern roleSchemaValuePattern;
    private boolean roleSchemaViaCredential;

    public void setRoleSchemaViaCredential(boolean roleSchemaViaCredential) {
        this.roleSchemaViaCredential = roleSchemaViaCredential;
    }

    public void init() {
        if (this.applicationKey == null) {
            throw new IllegalStateException("Required property 'applicationKey' not set");
        }
        if (this.roleSchemaViaCredential && this.roleSchemaValuePattern == null) {
            throw new IllegalStateException("Properties 'roleSchemaViaCredential' and 'roleSchemaValuePattern' are mutually exclusive.  If you want JaasAuthBean to manage roles or schemas, you must set property 'roleSchemaValuePattern'.");
        }
        this.initialized = true;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public void setRoleSchemaValuePattern(Pattern roleSchemaValuePattern) {
        this.roleSchemaValuePattern = roleSchemaValuePattern;
    }

    public void setRoleSchemaValuePatternString(String patternString) {
        this.setRoleSchemaValuePattern(Pattern.compile(patternString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] authenticate(String userName, String password) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + JaasAuthBean.class.getName() + " instance.");
        }
        try {
            LoginContext lc = new LoginContext(this.applicationKey, new UPCallbackHandler(userName, password));
            try {
                lc.login();
            }
            catch (LoginException le) {
                logger.finer("JSSE backend denying access:  " + le);
                throw new DenyException();
            }
            try {
                if (this.roleSchemaValuePattern == null) {
                    String[] le = null;
                    return le;
                }
                int i = 0;
                Matcher m = null;
                ArrayList<String> rsCandidates = new ArrayList<String>();
                ArrayList<String> rsList = new ArrayList<String>();
                Subject s = lc.getSubject();
                if (this.roleSchemaViaCredential) {
                    for (Object cred : new ArrayList<Object>(s.getPublicCredentials())) {
                        rsCandidates.add(cred.toString());
                    }
                } else {
                    for (Principal p : new ArrayList<Principal>(s.getPrincipals())) {
                        rsCandidates.add(p.getName());
                    }
                }
                logger.finer(Integer.toString(rsCandidates.size()) + " candidate " + (this.roleSchemaViaCredential ? "Credentials" : "Principals"));
                for (String candid : rsCandidates) {
                    m = this.roleSchemaValuePattern.matcher(candid);
                    if (m.matches()) {
                        logger.finer("    +" + ++i + ": " + (m.groupCount() > 0 ? m.group(1) : candid));
                        rsList.add(m.groupCount() > 0 ? m.group(1) : candid);
                        continue;
                    }
                    logger.finer("    -" + ++i + ": " + candid);
                }
                String[] stringArray = rsList.toArray(new String[0]);
                return stringArray;
            }
            finally {
                lc.logout();
            }
        }
        catch (LoginException le) {
            logger.severe("System JaasAuthBean failure", le);
            throw new RuntimeException(le);
        }
        catch (RuntimeException re) {
            logger.severe("System JaasAuthBean failure", re);
            throw re;
        }
    }

    public static class UPCallbackHandler
    implements CallbackHandler {
        private String u;
        private char[] p;

        public UPCallbackHandler(String u, String pString) {
            this.u = u;
            this.p = pString.toCharArray();
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            boolean didSetName = false;
            boolean didSetPassword = false;
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.u);
                    didSetName = true;
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.p);
                    didSetPassword = true;
                    continue;
                }
                throw new UnsupportedCallbackException(cb, "Unsupported Callback type: " + cb.getClass().getName());
            }
            if (!didSetName) {
                throw new IllegalStateException("Supplied Callbacks does not include a NameCallback");
            }
            if (!didSetPassword) {
                throw new IllegalStateException("Supplied Callbacks does not include a PasswordCallback");
            }
        }
    }
}

