/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.Util;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCArrayBasic
implements Array {
    Type arrayType;
    Type elementType;
    Object[] data;

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() {
        return this.data;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, index - 1L, count)) {
            throw Util.outOfRangeArgument();
        }
        Object[] slice = new Object[count];
        for (int i = 0; i < count; ++i) {
            slice[i] = this.data[(int)index + i - 1];
        }
        return slice;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(0L, this.data.length);
        return JDBCResultSet.newJDBCResultSet(result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(index - 1L, count);
        return new JDBCResultSet(null, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(index, count);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = Type.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() throws SQLException {
    }

    public JDBCArrayBasic(Object[] data, Type type) {
        this.data = data;
        this.elementType = type;
    }

    Object[] getArrayInternal() {
        return this.data;
    }

    private Result newColumnResult(long position, int count) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, position, count)) {
            throw Util.outOfRangeArgument();
        }
        Type[] types = new Type[]{Type.SQL_INTEGER, this.elementType};
        ResultMetaData meta = ResultMetaData.newSimpleResultMetaData(types);
        meta.columnLabels = new String[]{"C1", "C2"};
        meta.colIndexes = new int[]{-1, -1};
        meta.columns = new ColumnBase[2];
        for (int i = 0; i < meta.columns.length; ++i) {
            ColumnBase column = new ColumnBase("", "", "", "");
            column.setType(types[i]);
            meta.columns[i] = column;
        }
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        int i = (int)position;
        while ((long)i < position + (long)count) {
            Object[] rowData = new Object[]{i + 1, this.data[i]};
            navigator.add(rowData);
            ++i;
        }
        Result result = Result.newDataResult(meta);
        result.setNavigator(navigator);
        return result;
    }

    private void checkClosed() throws SQLException {
    }
}

