/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.KMPSearchAlgorithm;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private String m_data;
    private final boolean m_createdByConnection;

    public long length() throws SQLException {
        return this.getData().length();
    }

    public String getSubString(long pos, int length) throws SQLException {
        String data = this.getData();
        int dlen = data.length();
        if (pos < 1L || pos > (long)dlen) {
            Util.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0 || (long)length > (long)dlen - --pos) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        return pos == 0L && length == dlen ? data : data.substring((int)pos, (int)pos + length);
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getData());
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.getData().getBytes("US-ASCII"));
        }
        catch (IOException e) {
            return null;
        }
    }

    public long position(String searchstr, long start) throws SQLException {
        String data = this.getData();
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null || start > 0x80000000L) {
            return -1L;
        }
        int position = KMPSearchAlgorithm.search(data, searchstr, null, (int)start);
        return position == -1 ? -1L : (long)(position + 1);
    }

    public long position(Clob searchstr, long start) throws SQLException {
        long sslen;
        String data = this.getData();
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null) {
            return -1L;
        }
        long dlen = data.length();
        if (--start > dlen - (sslen = searchstr.length())) {
            return -1L;
        }
        String pattern = searchstr instanceof JDBCClob ? ((JDBCClob)searchstr).data() : searchstr.getSubString(1L, (int)sslen);
        int position = KMPSearchAlgorithm.search(data, pattern, null, (int)start);
        return position == -1 ? -1L : (long)(position + 1);
    }

    public int setString(long pos, String str) throws SQLException {
        if (str == null) {
            throw Util.nullArgument("str");
        }
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        StringBuffer sb;
        if (!this.m_createdByConnection) {
            throw Util.notSupported();
        }
        String data = this.getData();
        if (str == null) {
            throw Util.nullArgument("str");
        }
        int strlen = str.length();
        if (offset < 0 || offset > strlen) {
            throw Util.outOfRangeArgument("offset: " + offset);
        }
        if (len > strlen - offset) {
            throw Util.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos > 1L + (long)(Integer.MAX_VALUE - len)) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        int ipos = (int)(pos - 1L);
        int dlen = data.length();
        if (ipos > dlen - len) {
            sb = new StringBuffer(ipos + len);
            sb.append(data.substring(0, ipos));
            data = null;
            sb.append(str.substring(offset, offset + len));
            str = null;
        } else {
            sb = new StringBuffer(data);
            data = null;
            int i = ipos;
            for (int j = 0; j < len; ++j) {
                sb.setCharAt(i, str.charAt(offset + j));
                ++i;
            }
            str = null;
        }
        this.setData(sb.toString());
        return len;
    }

    public OutputStream setAsciiStream(final long pos) throws SQLException {
        if (!this.m_createdByConnection) {
            throw Util.notSupported();
        }
        this.checkClosed();
        if (pos < 1L || pos > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        return new ByteArrayOutputStream(){

            public synchronized void close() throws IOException {
                try {
                    try {
                        JDBCClob.this.setString(pos, new String(this.toByteArray(), "US-ASCII"));
                    }
                    catch (SQLException se) {
                        throw JavaSystem.toIOException(se);
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    super.close();
                    throw throwable;
                }
                super.close();
            }
        };
    }

    public Writer setCharacterStream(final long pos) throws SQLException {
        if (!this.m_createdByConnection) {
            throw Util.notSupported();
        }
        this.checkClosed();
        if (pos < 1L || pos > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        return new StringWriter(){

            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(pos, this.toString());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
            }
        };
    }

    public void truncate(long len) throws SQLException {
        String data = this.getData();
        long dlen = data.length();
        if (len != dlen) {
            if (len < 0L || len > dlen) {
                throw Util.outOfRangeArgument("len: " + len);
            }
            this.setData(data.substring(0, (int)len));
        }
    }

    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        return new StringReader(this.getSubString(pos, (int)length));
    }

    public JDBCClob(String data) throws SQLException {
        if (data == null) {
            throw Util.nullArgument();
        }
        this.m_data = data;
        this.m_createdByConnection = false;
    }

    protected JDBCClob() {
        this.m_data = "";
        this.m_createdByConnection = true;
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw Util.sqlException(1251);
        }
    }

    protected String data() throws SQLException {
        return this.getData();
    }

    private synchronized String getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(String data) throws SQLException {
        this.checkClosed();
        this.m_data = data;
    }
}

