/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hsqldb.FunctionCustom;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.Type;

public class JDBCDatabaseMetaData
implements DatabaseMetaData {
    static final Integer INT_COLUMNS_NO_NULLS = new Integer(0);
    private JDBCConnection connection;
    private final boolean useSchemaDefault;
    private static final String BRI_SESSION_SCOPE_IN_LIST = "(2)";
    private static final String BRI_TEMPORARY_SCOPE_IN_LIST = "(0,1,2)";
    private static final String BRI_TRANSACTION_SCOPE_IN_LIST = "(1,2)";
    private static final String selstar = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String whereTrue = " WHERE TRUE";
    public static final int JDBC_MAJOR = 3;

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        ResultSet rs = this.execute("CALL USER()");
        rs.next();
        String result = rs.getString(1);
        rs.close();
        return result;
    }

    public boolean isReadOnly() throws SQLException {
        ResultSet rs = this.execute("CALL IS_READONLY_DATABASE()");
        rs.next();
        boolean result = rs.getBoolean(1);
        rs.close();
        return result;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "HSQL Database Engine";
    }

    public String getDatabaseProductVersion() throws SQLException {
        ResultSet rs = this.execute("call database_version()");
        rs.next();
        return rs.getString(1);
    }

    public String getDriverName() throws SQLException {
        return "HSQL Database Engine Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "2.1.0";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "";
    }

    public String getNumericFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupNumericFunctions, ",", "");
    }

    public String getStringFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupStringFunctions, ",", "");
    }

    public String getSystemFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupSystemFunctions, ",", "");
    }

    public String getTimeDateFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupDateTimeFunctions, ",", "");
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        Type from = Type.getDefaultTypeWithSize(Type.getHSQLDBTypeCode(fromType));
        Type to = Type.getDefaultTypeWithSize(Type.getHSQLDBTypeCode(toType));
        if (from == null || to == null) {
            return false;
        }
        if (fromType == 0 && toType == 2003) {
            return true;
        }
        return to.canConvertFrom(from);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws SQLException {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 128;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 128;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 128;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        ResultSet rs = this.execute("CALL DATABASE_ISOLATION_LEVEL()");
        rs.next();
        String result = rs.getString(1);
        rs.close();
        if (result.startsWith("READ COMMITTED")) {
            return 2;
        }
        if (result.startsWith("READ UNCOMMITTED")) {
            return 1;
        }
        if (result.startsWith("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 1 || level == 2 || level == 4 || level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(procedureNamePattern)) {
            return this.executeSelect("SYSTEM_PROCEDURES", "0=1");
        }
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_PROCEDURES").append(JDBCDatabaseMetaData.and("PROCEDURE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", schemaPattern)).append(JDBCDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", procedureNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(procedureNamePattern) || JDBCDatabaseMetaData.wantsIsNull(columnNamePattern)) {
            return this.executeSelect("SYSTEM_PROCEDURECOLUMNS", "0=1");
        }
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_PROCEDURECOLUMNS").append(JDBCDatabaseMetaData.and("PROCEDURE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", schemaPattern)).append(JDBCDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", procedureNamePattern)).append(JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", columnNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(tableNamePattern) || types != null && types.length == 0) {
            return this.executeSelect("SYSTEM_TABLES", "0=1");
        }
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_TABLES").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", schemaPattern)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern));
        if (types != null) {
            select.append(" AND TABLE_TYPE IN (").append(StringUtil.getList(types, ",", "'")).append(')');
        }
        return this.execute(select.toString());
    }

    public ResultSet getSchemas() throws SQLException {
        return this.executeSelect("SYSTEM_SCHEMAS", null);
    }

    public ResultSet getCatalogs() throws SQLException {
        String select = "SELECT CATALOG_NAME AS TABLE_CAT FROM INFORMATION_SCHEMA.INFORMATION_SCHEMA_CATALOG_NAME";
        return this.execute(select);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.executeSelect("SYSTEM_TABLETYPES", null);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(tableNamePattern) || JDBCDatabaseMetaData.wantsIsNull(columnNamePattern)) {
            return this.executeSelect("SYSTEM_COLUMNS", "0=1");
        }
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_COLUMNS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", schemaPattern)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern)).append(JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", columnNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw Util.nullArgument("table");
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        String sql = "SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM,TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE TRUE " + JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", catalog) + JDBCDatabaseMetaData.and("TABLE_SCHEMA", "=", schema) + JDBCDatabaseMetaData.and("TABLE_NAME", "=", table) + JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", columnNamePattern);
        return this.execute(sql);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        String sql = "SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM,TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TRUE " + JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", catalog) + JDBCDatabaseMetaData.and("TABLE_SCHEMA", "LIKE", schemaPattern) + JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", tableNamePattern);
        return this.execute(sql);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String scopeIn;
        if (table == null) {
            throw Util.nullArgument("table");
        }
        switch (scope) {
            case 0: {
                scopeIn = BRI_TEMPORARY_SCOPE_IN_LIST;
                break;
            }
            case 1: {
                scopeIn = BRI_TRANSACTION_SCOPE_IN_LIST;
                break;
            }
            case 2: {
                scopeIn = BRI_SESSION_SCOPE_IN_LIST;
                break;
            }
            default: {
                throw Util.invalidArgument("scope");
            }
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        Integer Nullable = nullable ? null : INT_COLUMNS_NO_NULLS;
        StringBuffer select = this.toQueryPrefix("SYSTEM_BESTROWIDENTIFIER").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", table)).append(JDBCDatabaseMetaData.and("NULLABLE", "=", Nullable)).append(" AND SCOPE IN " + scopeIn);
        return this.execute(select.toString());
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.nullArgument("table");
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_VERSIONCOLUMNS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", table));
        return this.execute(select.toString());
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.nullArgument("table");
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_PRIMARYKEYS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", table));
        return this.execute(select.toString());
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.nullArgument("table");
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("FKTABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("FKTABLE_SCHEM", "=", schema)).append(JDBCDatabaseMetaData.and("FKTABLE_NAME", "=", table)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        return this.execute(select.toString());
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.nullArgument("table");
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("PKTABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("PKTABLE_SCHEM", "=", schema)).append(JDBCDatabaseMetaData.and("PKTABLE_NAME", "=", table));
        return this.execute(select.toString());
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (parentTable == null) {
            throw Util.nullArgument("parentTable");
        }
        if (foreignTable == null) {
            throw Util.nullArgument("foreignTable");
        }
        parentCatalog = this.translateCatalog(parentCatalog);
        foreignCatalog = this.translateCatalog(foreignCatalog);
        parentSchema = this.translateSchema(parentSchema);
        foreignSchema = this.translateSchema(foreignSchema);
        StringBuffer select = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("PKTABLE_CAT", "=", parentCatalog)).append(JDBCDatabaseMetaData.and("PKTABLE_SCHEM", "=", parentSchema)).append(JDBCDatabaseMetaData.and("PKTABLE_NAME", "=", parentTable)).append(JDBCDatabaseMetaData.and("FKTABLE_CAT", "=", foreignCatalog)).append(JDBCDatabaseMetaData.and("FKTABLE_SCHEM", "=", foreignSchema)).append(JDBCDatabaseMetaData.and("FKTABLE_NAME", "=", foreignTable));
        return this.execute(select.toString());
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.executeSelect("SYSTEM_TYPEINFO", null);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null) {
            throw Util.nullArgument("table");
        }
        catalog = this.translateCatalog(catalog);
        schema = this.translateSchema(schema);
        Boolean nu = unique ? Boolean.FALSE : null;
        StringBuffer select = this.toQueryPrefix("SYSTEM_INDEXINFO").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", schema)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", table)).append(JDBCDatabaseMetaData.and("NON_UNIQUE", "=", nu));
        return this.execute(select.toString());
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.supportsResultSetType(type) && (concurrency == 1007 || concurrency == 1008);
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(typeNamePattern) || types != null && types.length == 0) {
            this.executeSelect("SYSTEM_UDTS", "0=1");
        }
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefix("SYSTEM_UDTS").append(JDBCDatabaseMetaData.and("TYPE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TYPE_SCHEM", "LIKE", schemaPattern)).append(JDBCDatabaseMetaData.and("TYPE_NAME", "LIKE", typeNamePattern));
        if (types != null) {
            select.append(" AND DATA_TYPE IN (").append(StringUtil.getList(types, ",", "")).append(')');
        }
        return this.execute(select.toString());
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(typeNamePattern)) {
            return this.executeSelect("SYSTEM_SUPERTYPES", "0=1");
        }
        catalog = this.translateCatalog(catalog);
        schemaPattern = this.translateSchema(schemaPattern);
        StringBuffer select = this.toQueryPrefixNoSelect("SELECT * FROM (SELECT USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_SCHEMA, USER_DEFINED_TYPE_NAME,CAST (NULL AS INFORMATION_SCHEMA.SQL_IDENTIFIER), CAST (NULL AS INFORMATION_SCHEMA.SQL_IDENTIFIER), DATA_TYPE FROM INFORMATION_SCHEMA.USER_DEFINED_TYPES UNION SELECT DOMAIN_CATALOG, DOMAIN_SCHEMA, DOMAIN_NAME,NULL,NULL, DATA_TYPE FROM INFORMATION_SCHEMA.DOMAINS) AS SUPERTYPES(TYPE_CAT, TYPE_SCHEM, TYPE_NAME, SUPERTYPE_CAT, SUPERTYPE_SCHEM, SUPERTYPE_NAME) ").append(JDBCDatabaseMetaData.and("TYPE_CAT", "=", catalog)).append(JDBCDatabaseMetaData.and("TYPE_SCHEM", "LIKE", schemaPattern)).append(JDBCDatabaseMetaData.and("TYPE_NAME", "LIKE", typeNamePattern));
        return this.execute(select.toString());
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        StringBuffer select = this.toQueryPrefixNoSelect("SELECT TABLE_NAME AS TABLE_CAT, TABLE_NAME AS TABLE_SCHEM, TABLE_NAME, TABLE_NAME AS SUPERTABLE_NAME FROM INFORMATION_SCHEMA.TABLES ").append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", ""));
        return this.execute(select.toString());
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        StringBuffer select = this.toQueryPrefixNoSelect("SELECT TABLE_NAME AS TYPE_CAT, TABLE_NAME AS TYPE_SCHME, TABLE_NAME AS TYPE_NAME, TABLE_NAME AS ATTR_NAME, CAST(0 AS INTEGER) AS DATA_TYPE, TABLE_NAME AS ATTR_TYPE_NAME, CAST(0 AS INTEGER) AS ATTR_SIZE, CAST(0 AS INTEGER) AS DECIMAL_DIGITS, CAST(0 AS INTEGER) AS NUM_PREC_RADIX, CAST(0 AS INTEGER) AS NULLABLE, '' AS REMARK, '' AS ATTR_DEF, CAST(0 AS INTEGER) AS SQL_DATA_TYPE, CAST(0 AS INTEGER) AS SQL_DATETIME_SUB, CAST(0 AS INTEGER) AS CHAR_OCTECT_LENGTH, CAST(0 AS INTEGER) AS ORDINAL_POSITION, '' AS NULLABLE, '' AS SCOPE_CATALOG, '' AS SCOPE_SCHEMA, '' AS SCOPE_TABLE, CAST(0 AS SMALLINT) AS SCOPE_DATA_TYPE FROM INFORMATION_SCHEMA.TABLES ").append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", ""));
        return this.execute(select.toString());
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1 || holdability == 2;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        ResultSet rs = this.execute("call database_version()");
        rs.next();
        String v = rs.getString(1);
        rs.close();
        return Integer.parseInt(v.substring(0, v.indexOf(".")));
    }

    public int getDatabaseMinorVersion() throws SQLException {
        ResultSet rs = this.execute("call database_version()");
        rs.next();
        String v = rs.getString(1);
        rs.close();
        int start = v.indexOf(".") + 1;
        return Integer.parseInt(v.substring(start, v.indexOf(".", start)));
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Util.notSupported();
    }

    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    JDBCDatabaseMetaData(JDBCConnection c) throws SQLException {
        this.connection = c;
        this.useSchemaDefault = c.isInternal ? false : c.connProperties.isPropertyTrue("default_schema");
    }

    private static String and(String id, String op, Object val) {
        if (val == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isStr = val instanceof String;
        if (isStr && ((String)val).length() == 0) {
            return sb.append(" AND ").append(id).append(" IS NULL").toString();
        }
        String v = isStr ? Type.SQL_VARCHAR.convertToSQLString(val) : String.valueOf(val);
        sb.append(" AND ").append(id).append(' ');
        if (isStr && "LIKE".equalsIgnoreCase(op)) {
            if (v.indexOf(95) < 0 && v.indexOf(37) < 0) {
                sb.append("=").append(' ').append(v);
            } else {
                sb.append("LIKE").append(' ').append(v);
                if (v.indexOf("\\_") >= 0 || v.indexOf("\\%") >= 0) {
                    sb.append(" ESCAPE '\\'");
                }
            }
        } else {
            sb.append(op).append(' ').append(v);
        }
        return sb.toString();
    }

    private ResultSet execute(String sql) throws SQLException {
        int scroll = 1004;
        int concur = 1007;
        JDBCStatement st = (JDBCStatement)this.connection.createStatement(1004, 1007);
        st.maxRows = -1;
        ResultSet r = st.executeQuery(sql);
        ((JDBCResultSet)r).autoClose = true;
        return r;
    }

    private ResultSet executeSelect(String table, String where) throws SQLException {
        String select = selstar + table;
        if (where != null) {
            select = select + " WHERE " + where;
        }
        return this.execute(select);
    }

    private StringBuffer toQueryPrefix(String t) {
        StringBuffer sb = new StringBuffer(255);
        return sb.append(selstar).append(t).append(whereTrue);
    }

    private StringBuffer toQueryPrefixNoSelect(String t) {
        StringBuffer sb = new StringBuffer(255);
        return sb.append(t).append(whereTrue);
    }

    private static boolean wantsIsNull(String s) {
        return s != null && s.length() == 0;
    }

    String getDatabaseDefaultSchema() throws SQLException {
        ResultSet rs = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
        return rs.next() ? rs.getString(1) : null;
    }

    String getConnectionDefaultSchema() throws SQLException {
        ResultSet rs = this.execute("CALL CURRENT_SCHEMA");
        rs.next();
        String result = rs.getString(1);
        rs.close();
        return result;
    }

    void setConnectionDefaultSchema(String schemaName) throws SQLException {
        this.execute("SET SCHEMA " + StringConverter.toQuotedString(schemaName, '\"', true));
    }

    private String translateSchema(String schemaName) throws SQLException {
        String result;
        if (this.useSchemaDefault && schemaName != null && schemaName.length() == 0 && (result = this.getDatabaseDefaultSchema()) != null) {
            schemaName = result;
        }
        return schemaName;
    }

    String getDatabaseDefaultCatalog() throws SQLException {
        ResultSet rs = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
        return rs.next() ? rs.getString(2) : null;
    }

    private String translateCatalog(String catalogName) throws SQLException {
        String result;
        if (this.useSchemaDefault && catalogName != null && catalogName.length() == 0 && (result = this.getDatabaseDefaultCatalog()) != null) {
            catalogName = result;
        }
        return catalogName;
    }
}

