/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;

abstract class BaseList {
    protected int elementCount;

    BaseList() {
    }

    abstract Object get(int var1);

    abstract Object remove(int var1);

    abstract boolean add(Object var1);

    abstract int size();

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public int indexOf(Object o) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object current = this.get(i);
            if (!(current == null ? o == null : current.equals(o))) continue;
            return i;
        }
        return -1;
    }

    public boolean addAll(Collection other) {
        boolean result = false;
        Iterator it = other.iterator();
        while (it.hasNext()) {
            result = true;
            this.add(it.next());
        }
        return result;
    }

    public boolean addAll(Object[] array) {
        boolean result = false;
        for (int i = 0; i < array.length; ++i) {
            result = true;
            this.add(array[i]);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32 + this.elementCount * 3);
        sb.append("List : size=");
        sb.append(this.elementCount);
        sb.append(' ');
        sb.append('{');
        Iterator it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public Iterator iterator() {
        return new BaseListIterator();
    }

    private class BaseListIterator
    implements Iterator {
        int counter = 0;
        boolean removed;

        private BaseListIterator() {
        }

        public boolean hasNext() {
            return this.counter < BaseList.this.elementCount;
        }

        public Object next() {
            if (this.counter < BaseList.this.elementCount) {
                this.removed = false;
                Object returnValue = BaseList.this.get(this.counter);
                ++this.counter;
                return returnValue;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.removed) {
                throw new NoSuchElementException("Iterator");
            }
            this.removed = true;
            if (this.counter != 0) {
                BaseList.this.remove(this.counter - 1);
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }

        public void setValue(Object value) {
            throw new NoSuchElementException();
        }
    }
}

