/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Writer;

public class ClosableCharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;
    protected boolean closed;
    protected boolean freed;

    public ClosableCharArrayWriter() {
        this(32);
    }

    public ClosableCharArrayWriter(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new char[size];
    }

    public synchronized void write(int c) throws IOException {
        this.checkClosed();
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public synchronized void write(char[] c, int off, int len) throws IOException {
        this.checkClosed();
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public synchronized void write(String str, int off, int len) throws IOException {
        this.checkClosed();
        int strlen = str.length();
        if (off < 0 || off > strlen || len < 0 || off + len > strlen || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void flush() throws IOException {
        this.checkClosed();
    }

    public synchronized void writeTo(Writer out) throws IOException {
        this.checkFreed();
        if (this.count > 0) {
            out.write(this.buf, 0, this.count);
        }
    }

    public synchronized int capacity() throws IOException {
        this.checkFreed();
        return this.buf.length;
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.count = 0;
    }

    public synchronized void trimToSize() throws IOException {
        this.checkFreed();
        if (this.buf.length > this.count) {
            this.buf = this.copyOf(this.buf, this.count);
        }
    }

    public synchronized char[] toCharArray() throws IOException {
        this.checkFreed();
        return this.copyOf(this.buf, this.count);
    }

    public synchronized int size() throws IOException {
        return this.count;
    }

    public synchronized void setSize(int newSize) {
        if (newSize < 0) {
            throw new ArrayIndexOutOfBoundsException(newSize);
        }
        if (newSize > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newSize));
        }
        this.count = newSize;
    }

    public synchronized CharArrayReader toCharArrayReader() throws IOException {
        this.checkFreed();
        CharArrayReader reader = new CharArrayReader(this.buf, 0, this.count);
        this.free();
        return reader;
    }

    public synchronized String toString() {
        try {
            this.checkFreed();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        return new String(this.buf, 0, this.count);
    }

    public synchronized void close() throws IOException {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void free() throws IOException {
        this.closed = true;
        this.freed = true;
        this.buf = null;
        this.count = 0;
    }

    public synchronized boolean isFreed() {
        return this.freed;
    }

    protected synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed.");
        }
    }

    protected synchronized void checkFreed() throws IOException {
        if (this.freed) {
            throw new IOException("write buffer is freed.");
        }
    }

    protected char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

