/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobInputStream;

public class ClobDataID
implements ClobData {
    long id;
    long length = -1L;

    public ClobDataID(long id) {
        this.id = id;
    }

    public char[] getChars(SessionInterface session, long position, int length) {
        ResultLob resultOut = ResultLob.newLobGetCharsRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getCharArray();
    }

    public long length(SessionInterface session) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultOut = ResultLob.newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
        return this.length;
    }

    public String getSubString(SessionInterface session, long pos, int length) {
        char[] chars = this.getChars(session, pos, length);
        return new String(chars);
    }

    public ClobData getClob(SessionInterface session, long position, long length) {
        ResultLob resultOut = ResultLob.newLobGetRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return new ClobDataID(((ResultLob)resultIn).getLobID());
    }

    public void truncate(SessionInterface session, long len) {
        ResultLob resultOut = ResultLob.newLobTruncateRequest(this.id, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
    }

    public Reader getCharacterStream(SessionInterface session) {
        long length = this.length(session);
        return new ClobInputStream(session, this, 0L, length);
    }

    public long setCharacterStream(SessionInterface session, long pos, Reader in) {
        return 0L;
    }

    public int setString(SessionInterface session, long pos, String str) {
        ResultLob resultOut = ResultLob.newLobSetCharsRequest(this.id, pos, str.toCharArray());
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return str.length();
    }

    public int setString(SessionInterface session, long pos, String str, int offset, int len) {
        if (!ClobDataID.isInLimits(str.length(), offset, len)) {
            throw Error.error(3401);
        }
        ResultLob resultOut = ResultLob.newLobSetCharsRequest(this.id, pos, str.substring(offset, len).toCharArray());
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return str.length();
    }

    public int setChars(SessionInterface session, long pos, char[] chars, int offset, int len) {
        ResultLob resultOut;
        Result resultIn;
        if (offset != 0 || len != chars.length) {
            if (!ClobDataID.isInLimits(chars.length, offset, len)) {
                throw Error.error(3401);
            }
            char[] newChars = new char[len];
            System.arraycopy(chars, offset, newChars, 0, len);
            chars = newChars;
        }
        if ((resultIn = session.execute(resultOut = ResultLob.newLobSetCharsRequest(this.id, pos, chars))).isError()) {
            throw resultIn.getException();
        }
        return len;
    }

    public long position(SessionInterface session, String searchstr, long start) {
        ResultLob resultOut = ResultLob.newLobGetCharPatternPositionRequest(this.id, searchstr.toCharArray(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    public long position(SessionInterface session, ClobData searchstr, long start) {
        return 0L;
    }

    public long nonSpaceLength(SessionInterface session) {
        return 0L;
    }

    public Reader getCharacterStream(SessionInterface session, long pos, long length) {
        return new ClobInputStream(session, this, pos, length);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getRightTrimSize(SessionInterface session) {
        return 0L;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    public void setSession(SessionInterface session) {
    }

    public boolean isBinary() {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof BlobDataID) {
            return this.id == ((BlobDataID)other).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

