/*
 * Decompiled with CFR 0.152.
 */
package contribs.mx;

import contribs.mx.LongCounter;
import contribs.mx.S3ServiceErrorCodeTable;
import contribs.mx.S3ServiceMx;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class S3ServiceExceptionMx
implements DynamicMBean {
    private static final int E_NAME = 0;
    private static final int E_DESCR = 1;
    private static S3ServiceExceptionMx instance;
    private MBeanInfo info;
    private Map counters = Collections.synchronizedMap(new HashMap());

    public static void increment(String code) {
        try {
            S3ServiceExceptionMx.getInstance().incrementCounter(code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void increment() {
        S3ServiceExceptionMx.increment(S3ServiceErrorCodeTable.TABLE[0][0]);
    }

    public static void registerMBean() {
        S3ServiceExceptionMx.getInstance();
    }

    public static S3ServiceExceptionMx getInstance() {
        if (instance == null) {
            ObjectName name = S3ServiceMx.getObjectName("Type=S3ServiceException");
            instance = new S3ServiceExceptionMx();
            try {
                S3ServiceMx.registerMBean(instance, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public S3ServiceExceptionMx() {
        String[][] errors = S3ServiceErrorCodeTable.TABLE;
        for (int i = 0; i < errors.length; ++i) {
            this.counters.put(errors[i][0], new LongCounter());
        }
    }

    public void incrementCounter(String code) {
        LongCounter counter = this.getCounter(code);
        if (counter == null) {
            counter = new LongCounter();
            this.counters.put(code, counter);
        }
        counter.increment();
    }

    private LongCounter getCounter(String code) {
        return (LongCounter)this.counters.get(code);
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        LongCounter counter = this.getCounter(name);
        if (counter == null) {
            throw new AttributeNotFoundException(name);
        }
        return new Long(counter.getValue());
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            LongCounter counter = this.getCounter(name);
            long value = counter == null ? -1L : counter.getValue();
            list.add(new Attribute(name, new Long(value)));
        }
        return list;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.info != null) {
            return this.info;
        }
        String[][] errors = S3ServiceErrorCodeTable.TABLE;
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[errors.length];
        for (int i = 0; i < errors.length; ++i) {
            String[] error = errors[i];
            attrs[i] = new MBeanAttributeInfo(error[0], Long.class.getName(), error[1], true, false, false);
        }
        this.info = new MBeanInfo(this.getClass().getName(), "S3ServiceException MBean", attrs, null, null, null);
        return this.info;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new IllegalArgumentException();
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new IllegalArgumentException();
    }

    public AttributeList setAttributes(AttributeList attributes) {
        throw new IllegalArgumentException();
    }
}

