/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;

public class AlloyPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, String portletId, String controller, String actionId) throws PortalException {
        if (!AlloyPermission.contains(permissionChecker, groupId, portletId, controller, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(ThemeDisplay themeDisplay, String controller, String actionId) throws PortalException {
        if (!AlloyPermission.contains(themeDisplay, controller, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String portletId, String controller, String actionId) {
        actionId = String.valueOf(StringUtil.toUpperCase((String)actionId)) + "_" + StringUtil.toUpperCase((String)controller);
        try {
            ResourceActionsUtil.checkAction((String)portletId, (String)actionId);
        }
        catch (NoSuchResourceActionException noSuchResourceActionException) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, portletId, groupId, actionId);
    }

    public static boolean contains(ThemeDisplay themeDisplay, String controller, String actionId) {
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return AlloyPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletDisplay.getRootPortletId(), controller, actionId);
    }
}

