/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.php;

import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;

public class ServletContextPath
extends FilesystemPath {
    private URI _rootURI;
    private ServletContext _servletContext;
    private boolean _useRootURI;

    public ServletContextPath(ServletContext servletContext) {
        super(null, "/", "/");
        this._servletContext = servletContext;
        this._root = this;
        try {
            this._rootURI = ServletContextUtil.getRootURI((ServletContext)this._servletContext);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException();
        }
        this._useRootURI = true;
    }

    public boolean canRead() {
        return true;
    }

    public Path fsWalk(String userPath, Map<String, Object> newAttributes, String path) {
        int index;
        String authority = this._rootURI.getAuthority();
        if (Validator.isNotNull((String)authority) && (index = path.indexOf(authority)) != -1) {
            path = path.substring(index + authority.length());
        }
        return new ServletContextPath(this._root, userPath, path, this._servletContext);
    }

    public String getScheme() {
        if (this._useRootURI) {
            return this._rootURI.getScheme();
        }
        return "file";
    }

    public StreamImpl openReadImpl() throws IOException {
        String path = this.getPath();
        URL url = this._servletContext.getResource(path);
        if (url == null) {
            throw new FileNotFoundException(this.getFullPath());
        }
        return new VfsStream(url.openStream(), null);
    }

    protected ServletContextPath(FilesystemPath root, String userPath, String path, ServletContext servletContext) {
        super(root, userPath, path);
        this._servletContext = servletContext;
        try {
            this._rootURI = ServletContextUtil.getRootURI((ServletContext)this._servletContext);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException();
        }
        this._useRootURI = userPath.startsWith(this._rootURI.toString());
    }
}

