/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.client;

import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import org.apache.lucene.search.SortField;

public class BrowseRequestBuilder {
    private BrowseRequest _req;
    private String _qString;

    public BrowseRequestBuilder() {
        this.clear();
    }

    public BrowseRequestBuilder addSelection(String name, String val, boolean isNot) {
        BrowseSelection sel = this._req.getSelection(name);
        if (sel == null) {
            sel = new BrowseSelection(name);
        }
        if (isNot) {
            sel.addNotValue(val);
        } else {
            sel.addValue(val);
        }
        this._req.addSelection(sel);
        return this;
    }

    public BrowseRequestBuilder clearSelection(String name) {
        this._req.removeSelection(name);
        return this;
    }

    public BrowseRequestBuilder applyFacetSpec(String name, int minHitCount, int maxCount, boolean expand, FacetSpec.FacetSortSpec orderBy) {
        FacetSpec fspec = new FacetSpec();
        fspec.setMinHitCount(minHitCount);
        fspec.setMaxCount(maxCount);
        fspec.setExpandSelection(expand);
        fspec.setOrderBy(orderBy);
        this._req.setFacetSpec(name, fspec);
        return this;
    }

    public BrowseRequestBuilder applySort(SortField[] sorts) {
        if (sorts == null) {
            this._req.clearSort();
        } else {
            this._req.setSort(sorts);
        }
        return this;
    }

    public BrowseRequestBuilder clearFacetSpecs() {
        this._req.getFacetSpecs().clear();
        return this;
    }

    public BrowseRequestBuilder clearFacetSpec(String name) {
        this._req.getFacetSpecs().remove(name);
        return this;
    }

    public BrowseRequestBuilder setOffset(int offset) {
        this._req.setOffset(offset);
        return this;
    }

    public BrowseRequestBuilder setCount(int count) {
        this._req.setCount(count);
        return this;
    }

    public BrowseRequestBuilder setQuery(String qString) {
        this._qString = qString;
        return this;
    }

    public BrowseRequestBuilder clear() {
        this._req = new BrowseRequest();
        this._req.setOffset(0);
        this._req.setCount(5);
        this._req.setFetchStoredFields(true);
        this._qString = null;
        return this;
    }

    public BrowseRequestBuilder clearSelections() {
        this._req.clearSelections();
        return this;
    }

    public BrowseRequest getRequest() {
        return this._req;
    }

    public String getQueryString() {
        return this._qString;
    }
}

