/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.service.BrowseService;
import com.browseengine.bobo.service.BrowseServiceFactory;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class BrowseServiceImpl
implements BrowseService {
    private static final Logger logger = Logger.getLogger(BrowseServiceImpl.class);
    private final File _idxDir;
    private BoboIndexReader _reader;

    public BrowseServiceImpl(File idxDir) {
        this._idxDir = idxDir;
        try {
            this._reader = this.newIndexReader();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public BrowseServiceImpl() {
        this(new File(System.getProperty("index.directory")));
    }

    private BoboIndexReader newIndexReader() throws IOException {
        FSDirectory idxDir = FSDirectory.open((File)this._idxDir);
        return BrowseServiceImpl.newIndexReader((Directory)idxDir);
    }

    public static BoboIndexReader newIndexReader(Directory idxDir) throws IOException {
        BoboIndexReader reader;
        if (!IndexReader.indexExists((Directory)idxDir)) {
            return null;
        }
        long start = System.currentTimeMillis();
        IndexReader ir = IndexReader.open((Directory)idxDir, (boolean)true);
        try {
            reader = BoboIndexReader.getInstance(ir);
        }
        catch (IOException ioe) {
            try {
                ir.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw ioe;
        }
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("New index loading took: " + (end - start)));
        }
        return reader;
    }

    @Override
    public synchronized void close() throws BrowseException {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
        }
        catch (IOException e) {
            throw new BrowseException(e.getMessage(), e);
        }
    }

    @Override
    public BrowseResult browse(BrowseRequest req) throws BrowseException {
        return BrowseServiceFactory.createBrowseService(this._reader).browse(req);
    }
}

