/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.PrimitiveMatrix;
import java.lang.reflect.Array;

public class FloatMatrix
extends PrimitiveMatrix {
    private static final long serialVersionUID = 1L;

    public FloatMatrix(int[] sizes) {
        super(Float.TYPE, sizes);
    }

    public FloatMatrix() {
        super(Float.TYPE);
    }

    public synchronized void set(int x, int y, float n) {
        this.ensureCapacity(x, y);
        Object row = Array.get(this._matrix, x);
        if (row == null) {
            throw new ArrayIndexOutOfBoundsException("index out of bounds: " + x);
        }
        Array.setFloat(row, y, n);
        this._rowCount = Math.max(x, this._rowCount);
        this._colCount = Math.max(y, this._colCount);
    }

    public float get(int r, int c) {
        Object row = Array.get(this._matrix, r);
        if (row == null) {
            throw new ArrayIndexOutOfBoundsException("index out of bounds: " + r);
        }
        return Array.getFloat(row, c);
    }

    public synchronized float[][] toArray() {
        float[][] ret = new float[this._rowCount][this._colCount];
        for (int i = 0; i < this._rowCount; ++i) {
            Object row = Array.get(this._matrix, i);
            System.arraycopy(row, 0, ret[i], 0, this._colCount);
        }
        return ret;
    }
}

