/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.xsl;

import java.util.HashMap;
import java.util.Map;
import org.portletbridge.PortletBridgeException;
import org.portletbridge.StyleSheetRewriter;
import org.portletbridge.UrlRewriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class LinkRewriterXmlFilter
extends XMLFilterImpl {
    private String baseUrl = null;
    private UrlRewriter urlRewriter = null;
    private StyleSheetRewriter styleSheetRewriter = null;
    private String originalUrl;
    private Map context = new HashMap();
    private boolean inStyle = false;
    private StringBuffer styleContent = null;
    private static final Map elementsWithUrls = new HashMap();

    public LinkRewriterXmlFilter() {
    }

    public LinkRewriterXmlFilter(XMLReader parent) {
        super(parent);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("style".equalsIgnoreCase(localName) && !this.inStyle) {
            this.inStyle = true;
            this.styleContent = new StringBuffer();
        } else if (this.inStyle) {
            String rewrittenStyleContent;
            try {
                rewrittenStyleContent = this.styleSheetRewriter.rewrite(this.styleContent.toString());
            }
            catch (PortletBridgeException e) {
                throw new SAXException(e);
            }
            char[] chars = rewrittenStyleContent.toCharArray();
            super.characters(chars, 0, chars.length);
            this.inStyle = false;
        }
        String attr = (String)elementsWithUrls.get(localName.toLowerCase());
        if (attr != null) {
            int urlIndex = atts.getIndex(attr);
            if (urlIndex != -1) {
                String url = atts.getValue(urlIndex);
                AttributesImpl attributes = new AttributesImpl(atts);
                try {
                    attributes.setAttribute(urlIndex, atts.getURI(urlIndex), atts.getLocalName(urlIndex), atts.getQName(urlIndex), atts.getType(urlIndex), this.urlRewriter.rewrite(url));
                }
                catch (PortletBridgeException e) {
                    throw new SAXException(e);
                }
                super.startElement(uri, localName, qName, attributes);
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("style".equalsIgnoreCase(localName) && this.inStyle) {
            try {
                String rewrittenStyleContent = this.styleSheetRewriter.rewrite(this.styleContent.toString());
                char[] chars = rewrittenStyleContent.toCharArray();
                super.characters(chars, 0, chars.length);
                this.inStyle = false;
            }
            catch (PortletBridgeException e) {
                throw new SAXException(e);
            }
        }
        super.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inStyle) {
            this.styleContent.append(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    public void setUrlRewriter(UrlRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setStyleSheetRewriter(StyleSheetRewriter styleSheetRewriter) {
        this.styleSheetRewriter = styleSheetRewriter;
    }

    static {
        elementsWithUrls.put("a", "href");
        elementsWithUrls.put("base", "href");
        elementsWithUrls.put("link", "href");
        elementsWithUrls.put("area", "href");
        elementsWithUrls.put("img", "src");
        elementsWithUrls.put("input", "src");
        elementsWithUrls.put("frame", "src");
        elementsWithUrls.put("iframe", "src");
        elementsWithUrls.put("embed", "src");
        elementsWithUrls.put("xml", "src");
        elementsWithUrls.put("script", "src");
        elementsWithUrls.put("form", "action");
    }
}

