/*
 * Decompiled with CFR 0.152.
 */
package com.megginson.sax.rdf;

import com.megginson.sax.rdf.RDFException;
import com.megginson.sax.rdf.RDFHandler;
import com.megginson.sax.rdf.RDFReader;
import java.io.FileReader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestRDFFilter
extends DefaultHandler
implements RDFHandler {
    static int errorStatus = 0;

    public static void main(String[] stringArray) throws Exception {
        TestRDFFilter testRDFFilter = new TestRDFFilter();
        RDFReader rDFReader = new RDFReader();
        rDFReader.setRDFHandler(testRDFFilter);
        rDFReader.setContentHandler(testRDFFilter);
        rDFReader.setErrorHandler(testRDFFilter);
        if (stringArray.length != 1) {
            System.err.println("Usage: java TestRDFFilter <file-or-URL>");
            System.exit(2);
        }
        try {
            try {
                FileReader fileReader = new FileReader(stringArray[0]);
                rDFReader.readRDF(fileReader);
                fileReader.close();
            }
            catch (IOException iOException) {
                rDFReader.readRDF(stringArray[0]);
            }
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw sAXException.getException();
            }
            throw sAXException;
        }
        System.exit(errorStatus);
    }

    public void literalStatement(int n, String string, String string2, String string3, String string4) {
        System.out.print("{" + string2 + ", " + string + ", \"");
        char[] cArray = string3.toCharArray();
        this.showCharacters(cArray, 0, cArray.length);
        System.out.println("\" (lang=" + string4 + ")}");
    }

    public void resourceStatement(int n, String string, String string2, String string3) {
        System.out.println("{" + string2 + ", " + string + ", " + string3 + '}');
    }

    public void startXMLStatement(int n, String string, String string2, String string3) {
        System.out.println("{" + string2 + ", " + string + ", [start xml lang=" + string3 + "]}");
    }

    public void endXMLStatement() {
        System.out.println("{[end xml]}");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        System.out.println("XML start element: " + string2);
    }

    public void endElement(String string, String string2, String string3) {
        System.out.println("XML end element: " + string2);
    }

    public void characters(char[] cArray, int n, int n2) {
        System.out.print("XML characters: ");
        this.showCharacters(cArray, n, n2);
        System.out.print("\n");
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        System.out.print("XML whitespace: ");
        this.showCharacters(cArray, n, n2);
        System.out.print("\n");
    }

    public void warning(SAXParseException sAXParseException) {
        if (sAXParseException instanceof RDFException) {
            System.err.println("*** RDF warning: " + sAXParseException.getMessage());
        } else {
            System.err.println("*** XML warning: " + sAXParseException.getMessage());
        }
        this.showLocation(sAXParseException);
        errorStatus = 1;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (sAXParseException instanceof RDFException) {
            System.err.println("*** RDF ERROR: " + sAXParseException.getMessage());
        } else {
            System.err.println("*** XML ERROR: " + sAXParseException.getMessage());
        }
        this.showLocation(sAXParseException);
        errorStatus = 1;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("*** FATAL XML ERROR: " + sAXParseException.getMessage());
        this.showLocation(sAXParseException);
        errorStatus = 1;
    }

    private void showLocation(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (string != null || n > -1 || n2 > -1) {
            System.out.print("*** (near");
            if (string != null) {
                System.out.print(" " + string);
            }
            if (n > -1) {
                System.out.print(" line " + n);
            }
            if (n2 > -1) {
                System.out.print(" column " + n2);
            }
            System.out.print(")\n");
        }
    }

    private void showCharacters(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            switch (cArray[n3]) {
                case '\\': {
                    System.out.print("\\\\");
                    break;
                }
                case '\"': {
                    System.out.print("\\\"");
                    break;
                }
                case '\n': {
                    System.out.print("\\n");
                    break;
                }
                case '\r': {
                    System.out.print("\\r");
                    break;
                }
                case '\t': {
                    System.out.print("\\t");
                    break;
                }
                default: {
                    System.out.print(cArray[n3]);
                }
            }
            ++n3;
        }
    }
}

