/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

public class TestTask
extends BaseTask {
    private boolean continuous = false;
    private String runFiles = null;
    private File dir = null;

    public void execute() throws BuildException {
        try {
            List<Project> projects;
            File baseDir = this.getProject().getBaseDir();
            Project baseProject = Workspace.getProject(baseDir);
            if (this.runFiles == null) {
                projects = Collections.singletonList(baseProject);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(this.runFiles, ",");
                projects = new LinkedList<Project>();
                while (tokenizer.hasMoreTokens()) {
                    Project runProject;
                    String runFilePath = tokenizer.nextToken().trim();
                    if (".".equals(runFilePath)) {
                        runProject = baseProject;
                    } else {
                        File runFile = new File(baseDir, runFilePath);
                        if (!runFile.isFile()) {
                            throw new BuildException(String.format("Run file %s does not exist (or is not a file).", runFile.getAbsolutePath()));
                        }
                        runProject = new Project(baseProject.getWorkspace(), baseDir, runFile);
                        runProject.setParent(baseProject);
                    }
                    projects.add(runProject);
                }
            }
            for (Project project : projects) {
                this.executeProject(project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void executeProject(Project project) throws Exception {
        System.out.println("Testing " + project.getPropertiesFile());
        project.clear();
        ProjectTester tester = project.getProjectTester();
        tester.setContinuous(this.continuous);
        if (this.dir != null) {
            tester.setCwd(this.dir);
        }
        tester.prepare();
        if (this.report(project)) {
            throw new BuildException("Failed to initialise for testing.");
        }
        int errors = tester.test();
        if (errors != 0) {
            if (errors > 0) {
                System.err.println(errors + " Error(s)");
            } else {
                System.err.println("Error " + errors);
            }
            throw new BuildException("Tests failed");
        }
        System.err.println("All tests passed");
        if (this.report(project)) {
            throw new BuildException("Tests failed");
        }
    }

    public void setRunfiles(String runFiles) {
        this.runFiles = runFiles;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }
}

