/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.DownloadBlocker;
import aQute.bnd.build.Project;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.Strategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    private final File file;
    private final String path;
    final TYPE type;
    final String bsn;
    final String version;
    final String error;
    final Project project;
    final DownloadBlocker db;
    volatile Map<String, String> attributes;
    private long manifestTime;
    private Manifest manifest;

    Container(Project project, String bsn, String version, TYPE type, File source, String error, Map<String, String> attributes, DownloadBlocker db) {
        this.bsn = bsn;
        this.version = version;
        this.type = type;
        this.file = source != null ? source : new File("/" + bsn + ":" + version + ":" + (Object)((Object)type));
        this.path = this.file.getAbsolutePath();
        this.project = project;
        this.error = error;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : attributes;
        this.db = db;
    }

    public Container(Project project, File file) {
        this(project, file.getName(), "project", TYPE.PROJECT, file, null, null, null);
    }

    public Container(File file, DownloadBlocker db) {
        this(null, file.getName(), "project", TYPE.EXTERNAL, file, null, null, db);
    }

    public File getFile() {
        if (this.db != null && this.db.getReason() != null) {
            return new File(this.db.getReason() + ": " + this.file);
        }
        return this.file;
    }

    public boolean contributeFiles(List<File> files, Processor reporter) throws Exception {
        switch (this.type) {
            case EXTERNAL: 
            case REPO: {
                files.add(this.getFile());
                return true;
            }
            case PROJECT: {
                File[] fs = this.project.build();
                reporter.getInfo(this.project);
                if (fs == null) {
                    return false;
                }
                for (File f : fs) {
                    files.add(f);
                }
                return true;
            }
            case LIBRARY: {
                List<Container> containers = this.getMembers();
                for (Container container : containers) {
                    if (container.contributeFiles(files, reporter)) continue;
                    return false;
                }
                return true;
            }
            case ERROR: {
                reporter.error(this.error, new Object[0]);
                return false;
            }
        }
        return false;
    }

    public String getBundleSymbolicName() {
        return this.bsn;
    }

    public String getVersion() {
        return this.version;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (other instanceof Container) {
            return this.path.equals(((Container)other).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public Project getProject() {
        return this.project;
    }

    public String toString() {
        if (this.getError() != null) {
            return "/error/" + this.getError();
        }
        return this.getFile().getAbsolutePath();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void putAttribute(String name, String value) {
        if (this.attributes == Collections.emptyMap()) {
            this.attributes = new HashMap<String, String>(1);
        }
        this.attributes.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Container> getMembers() throws Exception {
        List<Container> result = this.project.newList();
        if (this.getType() == TYPE.LIBRARY) {
            FileInputStream in = null;
            BufferedReader rd = null;
            try {
                String line;
                in = new FileInputStream(this.getFile());
                rd = new BufferedReader(new InputStreamReader((InputStream)in, Constants.DEFAULT_CHARSET));
                while ((line = rd.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() <= 0) continue;
                    List<Container> list = this.project.getBundles(Strategy.HIGHEST, line, null);
                    result.addAll(list);
                }
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        } else {
            result.add(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws Exception {
        if (this.getError() != null || this.getFile() == null) {
            return null;
        }
        if (this.manifestTime < this.getFile().lastModified()) {
            FileInputStream in = new FileInputStream(this.getFile());
            try {
                JarInputStream jin = new JarInputStream(in);
                this.manifest = jin.getManifest();
                jin.close();
                this.manifestTime = this.getFile().lastModified();
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return this.manifest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        REPO,
        PROJECT,
        EXTERNAL,
        LIBRARY,
        ERROR;

    }
}

